<?php
//
// Copyright (c) 2014 NetApp, Inc.
// All rights reserved.
//

// VERSION="1.0"
// NDU Compatibility for RDB

$epochmismatch = false;
$mastermismatch = false;
$unitoffline = false;
$i = 0;
$query = "SELECT unitname, epoch, db-epoch, master, online FROM cluster_ring";
$ringarray= array(array());

// ringarray[$x][0] is unitname.
// ringarray[$x][1] is master node name.
// ringarray[$x][2] is true if mismatch else false.

function master_match($unit,$masternode){
        global $i;
	global $ringarray;
	global $mastermismatch;

	for ($x=0; $x<$i; $x++){
          if ($ringarray[$x][0] == $unit) {
	    break;
	  }
	}
        if ( $x != $i ) {
             if ($ringarray[$x][1] != $masternode ) {
                $mastermismatch = true;
		$ringarray[$x][2] = true;
	     }
	} else {
           $ringarray[$x][0] = $unit;
	   $ringarray[$x][1] = $masternode;
	   $ringarray[$x][2] = false;
	   $i++;
	}
}

$result = dotsql_query($query);
while ($row = dotsql_fetch_object($result)) {
  if (empty($row->epoch) || empty($row->{'db-epoch'}) || $row->online == 'offline'){
        $unitoffline = true;
	break;
  } else if (($row->epoch != ($row->{'db-epoch'}))){
	$epochmismatch = true;
	break;
  }
  master_match($row->unitname, $row->master);
}

if ($epochmismatch == true || $mastermismatch == true || $unitoffline == true) {
echo "<Alert>Cluster is not in quorum.</Alert><Action>";
echo "For detailed information run the (privilege: advanced) command: \"cluster ring show\".</Action> <RC>error</RC>";
    echo "<Advice>Ensure cluster is in quorum.</Advice>";
}
exit;
?>
