<?php
//
//  Copyright (c) 2015 NetApp, Inc.
//  All rights reserved.
//
// VERSION="1.0"
// NFS netgroup check

$query = "SELECT package FROM cluster_licenses_v2";
$result = dotsql_query($query);

$query1 = "SELECT clientmatch FROM export_rule_table";
$result1 = dotsql_query($query1);

// If 8.3.1 capability is already present on any one node on the cluster, that means 
// this warning was emitted out already.
$query2 = "SELECT capability FROM capability WHERE capability='DATA_ONTAP.8.3.1'";
$result2 = dotsql_query($query2);

// If we have any results present from the above query, we simply exit and don't
// need to throw a warning.
if (dotsql_num_rows($result2)) {
    exit;
}

// If we don't have 8.3.1 capability on the filer, it is a good indication that we are
// upgrading to a image >= 8.3.1
while ($row = dotsql_fetch_object($result)) {
    $state = $row->{'package'};
    if ($state == 'NFS') {
        while ($row1 = dotsql_fetch_object($result1)) {
            $clientmatch = $row1->{'clientmatch'};
            if (preg_match('/^@/', $clientmatch)) {
                echo "<Alert>NFS and netgroups are in use.</Alert>";
                echo "<Action>Search for TR-4379: Name Services Best Practice Guide on www.netapp.com for information about PTR records before upgrading the cluster to this image.</Action>";
                echo "<Advice>Search for TR-4379: Name Services Best Practice Guide on www.netapp.com for information about PTR records before upgrading the cluster to this image.</Advice>";
                echo "<RC>warning</RC>";
                exit;
            }
        }
    }
}
exit;
?>
