<?php
//
//  Copyright (c) 2014 NetApp, Inc.
//  All rights reserved.
//
// VERSION="1.0"
// NDU Compatibility for SCON

// The first check is to verify a an HA pair has the same
// broadcast domains present on each node

include 'mcc_util.php';
include 'vserver_state_cache.php';

$MAX_BDOMAINS_TO_REPORT=3;

// create a mapping of node's to their partner we use this later to determine
// which node to compare broadcast domains to
$nodeQuery = "SELECT node, partner-name, state FROM storage_failover";
$nodeResult = dotsql_query($nodeQuery);
while( $nodeRow = dotsql_fetch_object($nodeResult)) {
    // if state is empty, then HA is not turned on for the node
    // so it has no partner
    if( $nodeRow->{'state'} ) {
	$node = $nodeRow->{'node'};
	$partner[$node] = $nodeRow->{'partner-name'};
    }
}

// get a list of broadcast domains for each node
// this code handles the unlikely event that some nodes
// in the cluster have HA turned on and some have it
// turned off
$nodeQuery = "SELECT node, broadcast-domain, ipspace FROM netports";
$nodeResult = dotsql_query($nodeQuery);
while( $nodeRow = dotsql_fetch_object($nodeResult)) {
    $node = $nodeRow->{'node'};

    // only get broadcast domains if the node has a partner
    if( $partner[$node] ){
	$ipspace = $nodeRow->{'ipspace'};
	$broadcastDomain = $nodeRow->{'broadcast-domain'};
	// handle the case where a port does not have an
	// associated broadcast domain. A port that is not
	// in a broadcast domain cannot host a lif so its
	// safe to treat the broadcast domain as though it
	// doesn't exist
	if( $broadcastDomain ){
	    // since we need the ipspace the broadcast domain
	    // resides in for reporting, we stash it away
	    // as an indicator a broadcast domain exists
	    // for that node
	    $nodeBD[$node][$ipspace][$broadcastDomain]=1;
	}
    }
}
// No additional processing necessary if there are no HA pairs
if( $nodeBD ){

    // remove every broadcast domain the HA pair has in common 
    while (list($node, $ipspaces) = each($nodeBD)) {
	$partnerNode = $partner[$node];
	while (list($ipspace, $bDomains) = each ($ipspaces)) {
	    while  (list($broadcastDomain, $value) = each($bDomains)) {
		if ($nodeBD[$partnerNode][$ipspace][$broadcastDomain]) {
		    unset( $nodeBD[$partnerNode][$ipspace][$broadcastDomain] );
		    unset( $nodeBD[$node][$ipspace][$broadcastDomain] );

		    # if no more broadcast domains exist, remove the
		    # parent entry for both the node and it's partner
		    if( 0 == count( $nodeBD[$node][$ipspace] )){
			unset( $nodeBD[$node][$ipspace] );
			if( 0 == count( $nodeBD[$node] )){
			    unset( $nodeBD[$node] );
			}
		    }
		    if( 0 == count( $nodeBD[$partnerNode][$ipspace] )){
			unset( $nodeBD[$partnerNode][$ipspace] );
			if( 0 == count( $nodeBD[$partnerNode] )){
			    unset( $nodeBD[$partnerNode] );
			}
		    }
		}
	    }
	} 
    }
}
if( $nodeBD ){
    // at this point, nodeBD contains the broadcast domains that are only
    // on node of the HA pair.  This isn't necessarily a problem if the 
    // only LIFS on that broadcast domain do not fail over.  So we need
    // to remove those broadcast domains from nodeBD
    unset ($errorMsg);
    reset ($nodeBD);

    // remove any broadcast domain that doesn't host lifs that fail over
    while (list($node, $ipspaces ) = each($nodeBD)){
	while ((list($ipspace, $bDomains) = each($ipspaces))) {
	    while (list($broadcastDomain, $value) = each($bDomains)) {

		$mustExistOnPartner = False;

		// get the broadcast domain id
		$bdQuery = "SELECT broadcast-domain-id from broadcast_domain_by_ipspace where ipspace='$ipspace' and broadcast-domain='$broadcastDomain'";
		$bdResult = dotsql_query($bdQuery);
		if ($bdRow = dotsql_fetch_object($bdResult)){
		    $bdId = $bdRow->{'broadcast-domain-id'}; 
		}
		else {
		    continue;
		}

		// get the ports in the broadcast domain local to the node
		$portQuery= "SELECT port_id_pkey from broadcast_domain_port_akey where node_id_col = '$node' and broadcast_domain_id_col=$bdId";
		$portResult = dotsql_query($portQuery);
		while($portRow = dotsql_fetch_object($portResult)){
		    $portId = $portRow->{'port_id_pkey'};

		    // check if there is a lif that can fail over on any port in that broadcast domain
		    // we only want data or cluster-mgmt, unfortunately, OR doesn't work for dotsql so
		    // we need to filter out what we don't want using AND.
		    // also, we only want to consider admin-up lifs on running vservers
		    // also disregard lifs with a failover policy of local-only 
		    $lifQuery = "SELECT vsrv_id_col from port_vif_akey WHERE current_port_fkey=$portId and vif_type_col<>node-mgmt and vif_type_col<>cluster and vif_type_col<>intercluster and vif_status_col=up and failover_policy_col<>local-only and failover_policy_col<>disabled";
		    $lifResult = dotsql_query($lifQuery);
		    while($lifRow = dotsql_fetch_object($lifResult)){
			$vserverId = $lifRow->{'vsrv_id_col'};

			// check if the vserver is running
			// get the vserver name for the id and check if it is running
			$vserverQuery = "SELECT name from sequential_identifier where namespace='virtual.servers' and id=$vserverId";
			$vserverResult = dotsql_query($vserverQuery);
			if( $vserverRow = dotsql_fetch_object($vserverResult) ){
			    $vserverName = $vserverRow->{'name'};
			    list($vserverState,$vserverType) = getVserverInfo($vserverName);
			    if( $vserverState == "running") {
				$mustExistOnPartner = True;
				break;
			    }
			    else{
			    }
			}
			else{
			    // this is the system vserver of the default ipspace which
			    // is always running
			}
		    }
		}

		// remove the broadcast domain if no lifs that can fail over use it
		if ($mustExistOnPartner == False) {
		    unset( $nodeBD[$node][$ipspace][$broadcastDomain] );

		    // if no more broadcast domains exist, remove the
		    // parent entry for both the node and it's partner
		    if( 0 == count( $nodeBD[$node][$ipspace] )){
			unset( $nodeBD[$node][$ipspace] );
			if( 0 == count( $nodeBD[$node] )){
			    unset( $nodeBD[$node] );
			}
		    }
		}
	    }
	}
    }
}

if($nodeBD) {
    unset ($errorMsg);
    reset ($nodeBD);

    $mismatchNodeCount = 0;
    $totalMismatchBDomains = 0;

    // we want to report the first MAX_BDOMAINS_TO_REPORT
    // broadcast domains, the remaining number of nodes
    // that has missing broadcast domains without any
    // mention of the specific broadcast domain missing to
    // conserve space in the output string

    // any broadcast domains remaining are not present on its partner
    // if there are no mismatched broadcast domains, the $nodeBD
    // will be empty
    while (list($node, $ipspaces ) = each($nodeBD)){

	if( $totalMismatchBDomains <= $MAX_BDOMAINS_TO_REPORT){

	    unset ($missingBDomains);
	    unset ($missingBDomainCount);
	    $firstMissingBD = 1;

	    while (list($ipspace, $bDomains) = each($ipspaces)){

		while (list($broadcastDomain, $value) = each($bDomains)) {

		    $totalMismatchBDomains++;

		    if( $totalMismatchBDomains <= $MAX_BDOMAINS_TO_REPORT){
			if( $nodeBD[$node][$ipspace][$broadcastDomain] ) {

			    if( $firstMissingBD == 1 ){
				$firstMissingBD = 0;
			    }
			    else {
				$missingBDomains .= ","; 
			    }

			    $missingBDomains .= "\"$broadcastDomain\" in IPspace \"$ipspace\"";

			    $missingBDomainCount++;
			}
		    }
		}
	    }

	    if( $missingBDomains ){
		$msg = "Node \"$partner[$node]\" needs at least one port configured in the broadcast domain%s %s. ";
		if ( $missingBDomainCount == 1 ) {
		    $multi="";
		}
		else{
		    $multi="s";
		}
		$errorMsg .= sprintf( $msg, $multi, $missingBDomains );
	    }
	}
	else{
	    $mismatchNodeCount++;
	}

    }

    if( $mismatchNodeCount > 0){
	// this is where there are more nodes that have mismatched bdomains
	$errorMsg .= " There are $mismatchNodeCount additional nodes that have ports in broadcast domains not present on their partner.";
    }

    if( $errorMsg ){
	echo "<Alert>$errorMsg</Alert>";
	echo "<Action>To find the HA Pairs, use the \"storage failover show -fields partner-name\" command. To display ";
	echo "each port's broadcast-domain, use the \"network port show -node <node-name> -fields broadcast-domain\" command. ";
	echo "Broadcast-domain commands are found in the \"network port broadcast-domain\" command set.</Action>";
	echo "<Advice>Modify the broadcast domains to match the ports on HA pairs</Advice>";
	echo "<RC>error</RC>";
    }
}

exit;
?>

