<?php
//
//  Copyright (c) 2014 NetApp, Inc.
//  All rights reserved.
//

// VERSION="1.0"
// NDU Compatibility for cluster

include 'mcc_util.php';
global $mccconfigured;
global $mccswitchedover;
$lifsnothomefound = false;

if (!isValidMCCState()) {
    exit;
}

$smconfigured = isSMConfigured();

$lifquery= "SELECT vserver FROM vifsbyname WHERE is-home = 'false' AND role != 'cluster-mgmt'";
$lifresult = dotsql_query($lifquery);

if ($mccconfigured || $smconfigured) {
    while ($lifrow = dotsql_fetch_object($lifresult)) {
        $vserverlif = $lifrow->vserver;
        $syncdestquery = "SELECT subtype FROM vserver_ui WHERE vserver=$vserverlif";
	$syncdestresult = dotsql_query($syncdestquery);
	if ($syncdestrow = dotsql_fetch_object($syncdestresult)) {
            // For SnapMmirror ADR/VDR, skip this LIF and continue
            if( $syncdestrow->subtype == 'dp-destination') {
                continue;
            }
	    if ($syncdestrow->subtype != 'sync-destination') {
		$lifsnothomefound = true;
                break;
            }
	}
    }
} else {
    if (dotsql_num_rows($lifresult)) {
        $lifsnothomefound = true;
    }
}

if ($lifsnothomefound) {
        echo "<Alert>One or more LIFs are not on the home node, verify that all LIFs are on the home node before attempting NDU.</Alert>";
        echo "<Action>To check for LIFs which are not on their home node, use the command: network interface show -is-home false</Action>";
	echo "<Advice>Ensure that LIFs are on their home node.</Advice>";
        echo "<RC>error</RC>";
}
exit;
?>
