<?php
// 
// Copyright (c) 2012-2014 NetApp, Inc.
// All rights reserved.
//

// VERSION="1.0"

//
// Check that cluster health
//
$found = "false";
$printed = "false";

$query = "SELECT node, epsilon, eligibility, health FROM cluster";

$result = dotsql_query($query);
while ($row = dotsql_fetch_object($result)) {
   if ($row->health == "false") {
      if ($printed != "true") {
         echo "<Alert>";
         echo "The following nodes are unhealthy: $row->node";
         $printed = "true";
      } else {
         echo ", $row->node";
      }
   }
}
if ($printed == "true") {
   echo ".";
   echo "</Alert> <Action>";
   echo "Ensure all nodes are healthy before attempting NDU. ";
   echo "For more details run the command: cluster show -health false";
   echo "</Action> <RC>error</RC>";
   echo "<Advice>Check health of all nodes in the cluster.</Advice>";
exit;
}

$printed = "false";
$result = dotsql_query($query);
while ($row = dotsql_fetch_object($result)) {
     if ($row->eligibility != "true") {
        if ($printed != "true") {
	    echo "<Alert>";
	    echo "The following nodes are ineligible: $row->node";
	    $printed = "true";
	} else {
	    echo ", $row->node";
	}
     }
}
if ($printed == "true") {
   echo ".";
   echo "</Alert> <Action>";
   echo "Ensure all nodes are eligible before attempting NDU. ";
   echo "For more details run the command:cluster show -eligibility false";
   echo "</Action> <RC>error</RC>";
   echo "<Advice>Check eligibility of all nodes in the cluster.</Advice>";
}
exit;
?>
