<?php
//
//  Copyright (c) 2014 NetApp, Inc.
//  All rights reserved.
//

// VERSION="1.0"
// NDU Compatibility for metrocluster


    $mccconfigured = false;
    $mccswitchedover = false;

    function getMCCConfigState() {
        $mccstate = 'mcc-not-set';
        $mccquery = "SELECT local-configuration-state FROM metrocluster";
        $mccresult = dotsql_query($mccquery);
        if ($mccrow = dotsql_fetch_object($mccresult)) {
            $mccstate = $mccrow->{'local-configuration-state'};
        }
        return $mccstate;
    }

    function getMCCOperationState() {
        $drcstate = 'drc-not-set';
        $drcquery = "SELECT currentState FROM mccDRCOperation";
        $mccstate = getMCCConfigState();
        if ($mccstate == 'partially-configured' || $mccstate == 'configured') {
            $drcresult = dotsql_query($drcquery);
            if ($drcrow = dotsql_fetch_object($drcresult)) {
                $drcstate = $drcrow->currentState;
            }
        }
        return $drcstate;
    }

    function getLocalMode() {
        $localmode = 'mode-not-set';
        $mccquery = "SELECT local-configuration-state, local-mode FROM metrocluster";
        $mccresult = dotsql_query($mccquery);
        if ($mccrow = dotsql_fetch_object($mccresult)) {
            $mccstate = $mccrow->{'local-configuration-state'};
            if ($mccstate == 'partially-configured' || $mccstate == 'configured') {
                $localmode =  $mccrow->{'local-mode'};
            }
        }
        return $localmode;
    }


    // Valid states for performing Automated NDU are
    //  a. mcc not-configured
    //  b. mcc configured and DRC operation state normal
    //  c. mcc configured and local mode in switchover(DRC operation states are switchover-completed, healing-aggrs-completed and healing-roots-completed)
    function isValidMCCState() {
        global $mccconfigured;
        global $mccswitchedover;

        $mccstate = getMCCConfigState();
        if ($mccstate == 'partially-configured' || $mccstate == 'configured') {
            $mccconfigured = true;
            // Open up support for all MCC DRC Operation states
            // Removed the below check and now just check for normal and switchover
            // $drcstate = getMCCOperationState();
            // if ($drcstate == 'switchover-completed' || $drcstate == 'healing-aggrs-completed' || $drcstate == 'healing-roots-completed') {
            $localmode = getLocalMode();
            if($localmode == 'switchover') {
                $mccswitchedover = true;
            }
            // elseif ($drcstate != 'normal') {
            elseif ($localmode != 'normal') {
                echo "<Alert>Automated NDU is not supported when MetroCluster is in the operational mode \"$localmode\".</Alert>";
	        echo "<Action>Verify that MetroCluster is configured and in the operational mode \"normal\" before attempting NDU.</Action>";
	        echo "<Advice>Verify that MetroCluster is configured and in the operational mode \"normal\" before attempting NDU.</Advice>";
	        echo "<RC>error</RC>";
	        return false;
            }
        }
        elseif ($mccstate != 'not-configured') {
            echo "<Alert>Automated NDU is not supported when MetroCluster is in the configuration state \"$mccstate\".</Alert>";
	    echo "<Action>Verify that MetroCluster is configured and in the operational mode \"normal\" before attempting NDU.</Action>";
	    echo "<Advice>Verify that MetroCluster is configured and in the operational mode \"normal\" before attempting NDU.</Advice>";
            echo "<RC>error</RC>";
            return false;
        }
        return true;
    }

    //Find if the cluster is part of SnapMirror relationship
    function isSMConfigured() {
        $smquery = "SELECT * FROM snapmirror LIMIT 1";
        $smresult = dotsql_query($smquery);
        // 'snapmirror show' command returns rows only for destination cluster
        // Table is empty if the cluster has only source ADR/VDR volumes
        if (dotsql_num_rows($smresult)) {
            return true;
        }
        return false;
    }

    /*
     * Get options from the command line or web request
     *
     * @param string $options
     * @param array $longopts
     * @return array
     */
    function getoptreq ($options, $longopts)
    {
        if (PHP_SAPI === 'cli' || empty($_SERVER['REMOTE_ADDR']))  // command line
        {
            return getopt($options, $longopts);
        }
        else if (isset($_REQUEST))  // web script
        {
            $found = array();

            $shortopts = preg_split('@([a-z0-9][:]{0,2})@i', $options, 0, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY);
            $opts = array_merge($shortopts, $longopts);

            foreach ($opts as $opt)
            {
                if (substr($opt, -2) === '::')  // optional
                {
                    $key = substr($opt, 0, -2);

                    if (isset($_REQUEST[$key]) && !empty($_REQUEST[$key]))
                        $found[$key] = $_REQUEST[$key];
                    else if (isset($_REQUEST[$key]))
                        $found[$key] = false;
                }
                else if (substr($opt, -1) === ':')  // required value
                {
                    $key = substr($opt, 0, -1);

                    if (isset($_REQUEST[$key]) && !empty($_REQUEST[$key]))
                        $found[$key] = $_REQUEST[$key];
                }
                else if (ctype_alnum($opt))  // no value
                {
                    if (isset($_REQUEST[$opt]))
                        $found[$opt] = false;
                }
            }
            return $found;
        }

        return false;
    }
?>
