#/bin/sh
if [ -z "$1" ] ; then
	echo "Usage: $0 <primary/backup>"
	exit 1
fi
basedir="/mnt/jffs2_rootfs_$1"
checksums="$basedir/install/checksum.regfiles"
if [ ! -f "$checksums" ] ; then
	echo "$checksums does not exist."
	exit 1
fi

failed_count=0
while read old_md5 file ; do
	file=$basedir$file
	if [ ! -e "$file" ] ; then
		echo "FAIL: $file does not exist"
		let failed_count++
		continue
	fi
	new_md5=$(md5sum $file | cut -d" " -f1)
	if [ "$old_md5" != "$new_md5" ] ; then
		echo "FAIL: $file expected: $old_md5 got: $new_md5"
		let failed_count++
	fi
done < $checksums
exit $failed_count
