#!/bin/sh

. /usr/local/bin/sig_catcher

usage() {
    echo "Usage:  $0 <target>"
    echo ""
    echo "           <target> is  0 = mb, 1 = ioxm:"
    exit 1 
}

if ! [ -f /var/run/Carnegie ]; then
    echo "Command not applicable on this platform"
    exit 1
fi

if [ $# -lt 1 ]; then
    usage
fi

target=$1

# disable marvell from accessing prom
/usr/local/bin/mp_controller $target disable_marvell

# program proper contents depending on target
if [ $target -eq 0 ]; then
    /usr/local/bin/program_mp_eeprom.sh $target /firmware/Carnegie/switch/mp_contents_motherboard.txt
else
    /usr/local/bin/program_mp_eeprom.sh $target /firmware/Carnegie/switch/mp_contents_ioxm.txt
fi

# enable marvell access
/usr/local/bin/mp_controller $target enable_marvell
