#!/bin/sh

PATH=$PATH:/usr/local/bin

. sig_catcher

disable_monitoring=0
disable_management=0

platform=$(cat /var/run/platform)

sensor_mon_en="/tmp/sensorMonitorTaskUp"
expected_num_msghndlr_pids="14"

check_monitoring_enabled()
{
	# Check if sensor monitoring is enabled
	ipmi sensors monitor 2 | grep enabled >/dev/null
	ret_val=$?
	if [ 0 -eq $ret_val ]; then
		disable_monitoring=1
	fi

	# Check if thermal management is enabled
	ipmi sensors thermal 2 | grep enabled >/dev/null
	ret_val=$?
	if [ 0 -eq $ret_val ]; then
		disable_management=1
	fi
}

disable_monitoring()
{
	local err_code=1
	echo ""
	if [ 1 -eq $disable_monitoring ]; then
		# Disable sensor monitring
		ipmi sensors monitor 0 | grep disabled >/dev/null
		ret_val=$?
		if [ 1 -eq $ret_val ]; then
			echo "Could not disable Sensor Monitoring"
			disable_monitoring="2"
		fi
	fi
	if [ 1 -eq $disable_management ]; then
		# Disable thermal management
		ipmi sensors thermal 0 | grep disabled >/dev/null
		ret_val=$?
		if [ 1 -eq $ret_val ]; then
			echo "Could not disable Thermal Management"
			disable_management="2"
		fi
	fi
	# If we cannot disable monitoring\mgmt warn the user again
	if [[ 2 -eq $disable_monitoring || 2 -eq $disable_management ]]; then
		echo "Do you want to proceed? (y/n):"
		read input1
		if [ "$input1" = "y" ]; then
			echo "Proceeding.."
		else
			echo "Aborting command.."
			err_code=2
		fi
	else
		echo "Sensor monitoring\management disabled on this controller!"
	fi

	return $err_code
}

enable_monitoring()
{
	local err_code_1=0
	if [[ 0 -eq $disable_monitoring || 0 -eq $disable_management ]]; then
		echo ""
		echo "Re-enabling Sensor Monitoring and Thermal Management.."
		if [ 0 -eq $disable_monitoring ]; then
			# enable sensor monitring
			ipmi sensors monitor 1 | grep enabled >/dev/null
			ret_val=$?
			if [ 1 -eq $ret_val ]; then
				echo "Could not enable Sensor Monitoring"
			fi
		fi
		if [ 0 -eq $disable_management ]; then
			# enable thermal management
			ipmi sensors thermal 1 | grep enabled >/dev/null
			ret_val=$?
			if [ 1 -eq $ret_val ]; then
				echo "Could not enable Thermal Management"
			fi
		fi
	fi
	return $err_code_1
}

check_ontap_running()
{
	local err_code_2=0
	on_tap=$(cat /sys/class/hwmon/bbsp)
	if [[ "$on_tap" = "2f" ]]; then
		echo "Storage controller is operational. Continuing this command may lead to SP being reset"
		echo ""
		echo "Do you want to continue? (y/n):"
		read input
		if [[ "$input" = "n" ]] ; then
			echo "Aborting command.."
			err_code_2=1
		fi
	fi
	return $err_code_2
}

razor_warning()
{
	local err_code_3=0
	local os_str=$(cat /var/run/os_str)
	echo ""
	echo "You need to disable monitoring/management on the other controller!"
	echo ""
	echo "Please log into the other controller and disable sensor monitoring/management"
	echo "with the following commands:"
	echo "system sensors monitor 0"
	echo "system sensors thermal-mgmt 0"
	echo "Please also ensure that a $os_str is not running"
	echo ""
	echo "Then hit y to continue"
	echo ""
	echo "Do you want to continue the update? (y/n):"
	read input
	if [ "$input" = "n" ]; then
		echo "Aborting command..."
		err_code_3=2
	fi
	return $err_code_3
}

thermal_warning()
{
	local ret_val=0
	ret_val=$(pidof MsgHndlr | wc -w)
	# Check that the IPMI Stack is up and the monitoring task has been created
	if [[ -e $sensor_mon_en && $ret_val -eq $expected_num_msghndlr_pids ]]; then
		# Check if sensor monitoring is enabled
		ipmi sensors monitor 2 | grep enabled > /dev/null
		ret_val=$?
		if [ $ret_val -ne 0 ]; then
			# Check if thermal management is enabled
			ipmi sensors thermal 2 | grep enabled > /dev/null
			ret_val=$?
			if [ $ret_val -ne 0 ]; then
				return 0
			fi
		fi
		# Print warning..
		echo "Warning: Systems sensor monitoring/thermal management is enabled!"
	fi
}

case $1 in

	chk)
		thermal_warning
	;;
	chk_disable)
		check_ontap_running
		if [[ $? -eq 0 ]]; then
			check_monitoring_enabled
			if [[ 1 -eq $disable_monitoring || 1 -eq $disable_management ]]; then
				disable_monitoring
				result=$?
				if [[ $result -eq 2 ]]; then
					exit $result
				else
					if [[ "$platform" = "RazorL" ]]; then
						razor_warning
						ret=$?
						if [[ $ret -eq 2 ]]; then
							exit $ret
						fi
					fi
					exit $result
				fi
			else
				echo ""
				echo "Sensor monitoring\management disabled on this controller!"
				if [[ "$platform" = "RazorL" ]]; then
					razor_warning
					result=$?
					if [[ $result -eq 2 ]]; then
						#Abort without disabling monitoring
						exit 3
					else
						#Execute the command
						exit $result
					fi
				else
					exit 0
				fi
			fi
		else
			exit 3
		fi
	;;
	chk_enable)
		check_monitoring_enabled
		if [[ 0 -eq $disable_monitoring || 0 -eq $disable_management ]]; then
			enable_monitoring
			result=$?
			exit $result
		else
			exit 0
		fi
	;;
	enable)

		enable_monitoring
		result=$?
		exit $result
	;;
	disable)
		disable_monitoring=1
		disable_management=1
		disable_monitoring
		result=$?
		exit $result
	;;
	*)
		echo "Command not supported"
		exit 1
	;;
esac

exit 0

