#!/bin/sh

. /usr/local/bin/sig_catcher

platform=$(cat /var/run/platform)
brdrev=$(cat /var/run/boardrev)
razorl_rev_p2i=3

if [ -f /var/run/RazorL ] && [ "$brdrev" -lt "$razorl_rev_p2i" ] ; then
	echo "Request not applicable on pre-p2i RazorL motherboards"
	exit 1
fi

echo "Programming Controller Switch EEPROM. Reset switch for changes to be effective."
switch_file=$(ls /firmware/$platform/switch/controller_switch_img*.txt)
if [ -f "$switch_file" ]; then
	/usr/local/bin/switch ep_pgm < $switch_file
	upg_ret_val=$?
	if [ $upg_ret_val -eq 0 ]; then
		/usr/local/bin/switch_config_version.sh -f > /var/run/switch_version_controller
	fi
else
	echo "$switch_file cannot be found."
	upg_ret_val=1
fi
return $upg_ret_val
