#!/bin/sh
# This scripts prints port statistics.
# Ports have these accessible counters, including discard counters. Offsets:
# 0x10 InDiscardsLo Frame Counter
# 0x11 InDiscardsHi Frame Counter
# 0x12 InFiltered/Tcam Ctr Counter
# 0x13 Rx Frame Counter
# Syntax would be:
# switch read <port> <offset>
# <port> = 0x10 (wrench port), 0x12 (e0M), 0x14 (Midplane), 0x15 (SAS Expander), 0x16 (BMC)
# <offset> = 0x10, 0x11, 0x12, 0x13

. /usr/local/bin/sig_catcher

echo ==========================================
echo Internal Ethernet switch port statistics
echo ==========================================

echo =======================================
echo Wrench Port statistics
echo =======================================

echo switch read 0x10 0x10
switch read 0x10 0x10
echo
echo switch read 0x10 0x11
switch read 0x10 0x11
echo
echo switch read 0x10 0x12
switch read 0x10 0x12
echo
echo switch read 0x10 0x13
switch read 0x10 0x13
echo
echo =======================================
echo e0M Port statistics
echo =======================================

echo switch read 0x12 0x10
switch read 0x12 0x10
echo
echo switch read 0x12 0x11
switch read 0x12 0x11
echo
echo switch read 0x12 0x12
switch read 0x12 0x12
echo
echo switch read 0x12 0x13
switch read 0x12 0x13
echo

if [ $(cat /var/run/platform) == "RazorM" ]; then
	echo =======================================
	echo Midplane Port statistics
	echo =======================================

	echo switch read 0x14 0x10
	switch read 0x14 0x10
	echo
	echo switch read 0x14 0x11
	switch read 0x14 0x11
	echo
	echo switch read 0x14 0x12
	switch read 0x14 0x12
	echo
	echo switch read 0x14 0x13
	switch read 0x14 0x13
	echo
	echo =======================================
	echo SAS Expander Port statistics
	echo =======================================

	echo switch read 0x15 0x10
	switch read 0x15 0x10
	echo
	echo switch read 0x15 0x11
	switch read 0x15 0x11
	echo
	echo switch read 0x15 0x12
	switch read 0x15 0x12
	echo
	echo switch read 0x15 0x13
	switch read 0x15 0x13
	echo
fi

echo =======================================
echo BMC Port statistics
echo =======================================

echo switch read 0x16 0x10
switch read 0x16 0x10
echo
echo switch read 0x16 0x11
switch read 0x16 0x11
echo
echo switch read 0x16 0x12
switch read 0x16 0x12
echo
echo switch read 0x16 0x13
switch read 0x16 0x13

exit 0
