#!/bin/sh
. /usr/local/bin/sig_catcher

################################################################
# switch_bundled_file_version.sh
# Input: None
# Output: Prints switch version digits of bundled switch image file
# For e.g. Scripts will print 18 for Version18 SB_XXII ETHSW RZM
# Return: Returns 0 for success, 1 for failure
################################################################

version_flag=0
counter=0
version_str=""
ret_val=1
eth_rev=-1

platform=$(cat /var/run/platform)
switch_file=$(ls /firmware/$platform/switch/controller_switch_img*.txt)

if [ -f "$switch_file" ]; then
        while read line
        do
                hexstring=`echo $line | sed 's/\\r//g'`
                if [ $version_flag -eq 1 ] ; then
                        let counter=$counter+1
                        if [ $counter -gt 4 ] ; then
                                version_str=$line
                                ret_val=0
                                break;
                        fi
                fi
                if [ $hexstring == 'FFFF' ] || [ $hexstring == 'ffff' ] ; then
                        version_flag=1
                fi
        done < $switch_file
        if [ $ret_val -eq 0 ] ; then
                byte1=${version_str:1:1}
                byte2=${version_str:2:2}

                if [ $byte2 != '00' ] ; then
                        eth_rev=$byte1${byte2:1:1}
                else
                        eth_rev=$byte1
                fi
        fi
fi

echo $eth_rev
return $ret_val

