#!/bin/sh

. /usr/local/bin/sig_catcher

IPTABLES="/sbin/iptables"

brdrev=$(cat /var/run/boardrev)
razorl_rev_p2i=3

if [ -f "/var/run/RazorL" ] && [ $brdrev -lt $razorl_rev_p2i ] ; then
INET_IFACE="eth0";
else
INET_IFACE="eth0.32";
fi


usage() {
	echo "Usage: ssh_control.sh accepts only one argument."
	exit 1
}


if [ $# = 1 ]   ; then
    if [ $1 == "display" ] ; then
      $IPTABLES -L ssh_pkts 3
    fi
    if [ $1 == "relax" ] ; then
       $IPTABLES -R ssh_pkts 3 -p TCP -i $INET_IFACE -s 0/0 --dport 22 --syn \
       -m state --state NEW -m limit --limit 100/minute --limit-burst 100 -j ACCEPT
    fi
    if [ $1 == "tighten" ] ; then
       $IPTABLES -R ssh_pkts 3 -p TCP -i $INET_IFACE -s 0/0 --dport 22 --syn \
       -m state --state NEW -m limit --limit 20/minute --limit-burst 20 -j ACCEPT
    fi
else
	usage
	exit 1
fi

