#!/bin/sh
#
# This script prints basic information to identify this system as:
# GENERATED_ON=Sun Oct 16 00:06:54 GMT 2011
# SP_FW_VERSION=1.4
# SP_FW_BUILD_TIMESTAMP=Wed Nov 18 01:32:57 PST 2010
# SYSTEM_ID=178103686
# SYS_SERIAL_NUM=700000613267
# MB_SERIAL_NUM=5002262339
# MODEL=FAS2240-2
# HOSTNAME=vespa-qian-a
# PARTNER_SYSTEM_ID=Not present
# PARTNER_HOSTNAME=Not present

. /usr/local/bin/sig_catcher
echo "GENERATED_ON=$(date)"

sp_fw_version=$(/usr/local/bin/version.sh -e -r)
echo "SP_FW_VERSION=$sp_fw_version"

sp_fw_build_timestamp=$(grep RLM_package_version /install/Metadata | cut -d= -f2 | cut -d" " -f3,4,5,6,7,8,9,10)
echo "SP_FW_BUILD_TIMESTAMP=$sp_fw_build_timestamp"

if [ -s /mnt/logs/etc/rlm_config_from_filer ]
then 
	system_id=$(grep ^SYSTEM_ID /mnt/logs/etc/rlm_config_from_filer | cut -d" " -f2)
	sys_serial_num=$(grep ^SYS_SERIAL_NUM /mnt/logs/etc/rlm_config_from_filer | cut -d" " -f2)
	mb_serial_num=$(grep ^MB_SERIAL_NUM /mnt/logs/etc/rlm_config_from_filer | cut -d" " -f2)
	model=$(grep ^MODEL /mnt/logs/etc/rlm_config_from_filer | cut -d" " -f2)
	hostname=$(grep ^HOSTNAME /mnt/logs/etc/rlm_config_from_filer | cut -d" " -f2)
	partner_system_id=$(grep ^PARTNER_SYSTEM_ID /mnt/logs/etc/rlm_config_from_filer | cut -d" " -f2,3)
	partner_hostname=$(grep ^PARTNER_HOSTNAME /mnt/logs/etc/rlm_config_from_filer | cut -d" " -f2,3)
fi

echo "SYSTEM_ID=$system_id"
echo "SYS_SERIAL_NUM=$sys_serial_num"
echo "MB_SERIAL_NUM=$mb_serial_num"
echo "MODEL=$model"
echo "HOSTNAME=$hostname"
echo "PARTNER_SYSTEM_ID=$partner_system_id"
echo "PARTNER_HOSTNAME=$partner_hostname"
