#!/bin/ash
#
# This script prints runtime information for engineering to debug a problem.

. /usr/local/bin/sig_catcher


tail -n 36 /tmp/splog_collect_timestamp

echo ps
echo ==
ps

echo top
echo ======================================
/usr/bin/top -n 1

echo mount
echo =====
mount

echo free
echo ====
free

echo df -h
echo =====
df -h

echo cat /proc/meminfo
echo =================
cat /proc/meminfo

# Vespa specific configuration
if [ -f "/var/run/Vespa" ] ; then
	echo "system acp show" 
	echo ============================
	/usr/local/bin/oem_ipmi acp show

	echo "system acp sensors"
	echo ============================
	/usr/local/bin/oem_ipmi acp sensors

	echo "system acp model show"
	echo ==============================
	/usr/local/bin/oem_ipmi acp model_show

fi

# get the FRU LED status
	get_leds.sh

exit 0
