#!/bin/ash
#
# This script prints configurations for engineering to debug a problem.

. /usr/local/bin/sig_catcher

tail -n 36 /tmp/splog_collect_timestamp

echo 1. SP Basics:
echo ============

echo version 
echo ======= 
/usr/local/bin/version.sh -a

echo uptime 
echo ====== 
uptime 

echo date 
echo ==== 
date

echo whoami 
echo ====== 
whoami 

echo cat /mnt/logs/etc/rlm_config_from_filer
echo =======================================
cat /mnt/logs/etc/rlm_config_from_filer

echo cat /mnt/logs/etc/rlm_config_to_filer
echo =====================================
cat /mnt/logs/etc/rlm_config_to_filer

echo =================================
echo 2. Network Related Configurations:
echo =================================
echo ifconfig
echo ========
ifconfig

echo cat /etc/network/interfaces
echo ===========================
cat /etc/network/interfaces

echo cat /mnt/logs/etc/interfaces
echo ============================
cat /mnt/logs/etc/interfaces

echo cat /etc/resolv.conf
echo ===============================
cat /etc/resolv.conf

echo cat /var/log/blocked_ip - Current Blocked IP address
echo ====================================================
cat /var/log/blocked_ip

echo IPv4 route
echo ==========
route

echo IPv6 route
echo ==========
route -A inet6

echo ip -6 addr
echo ================================
ip -6 addr

echo cat /mnt/logs/etc/rlm_config_xtd_info
echo =====================================
cat /mnt/logs/etc/rlm_config_xtd_info

echo =================================================
echo 3. Other Configurations: SSH, RSA, HW assist, ACP
echo =================================================
echo cat /mnt/logs/etc/sp_ssh_config
echo =====================================
cat /mnt/logs/etc/sp_ssh_config

echo cat /mnt/logs/etc/trap_conf
echo ============================
cat /mnt/logs/etc/trap_conf

echo cat /mnt/logs/etc/takeover_conf
echo =============================
cat /mnt/logs/etc/takeover_conf

# FRU(9) reading on carngie/absolue takes 15-20 secs, it completely
# slowdown ontap's log collecting process and might hold on
# thermal shutdown process if ontap force to get log before shutdown.
# So change to use cached FRU based on: (speed up about 15 secs).
# (1) Ontap is adding function to keep updated FRU info
# (2) frulog can tell fru change process.
# (3) FRU change is not a frequent event. In the future, SP can add
# function to update this file in the event of FRU removal and plug-in event.
#
# This file is initialized at fru_rescan.sh by netapp_final_initscript
#
fruinfocachedfile="/mnt/logs/ipmi/fruinfocachedfile.txt"

# On vespa,  midplane FRU is not ready at netapp_final_initscript
# Do it here...
if [ -f /var/run/RazorS ] || [ -f /var/run/RazorM ] ; then
        grep "inventory data access failed" < $fruinfocachedfile
        if [ "$?" -eq 0 ] ||  ![ -f $fruinfocachedfile ] ; then
                /etc/init.d/fru_cache.sh
        fi
fi

if [ -f $fruinfocachedfile ]
then
        echo cat $fruinfocachedfile
        echo =====================
        cat $fruinfocachedfile
fi

echo /usr/local/bin/frulogshow
echo ===============================
/usr/local/bin/frulogshow 3

show_hw_info.sh

echo /usr/local/bin/psu_dump
echo ==================================================
/usr/local/bin/psu_dump

echo ==================================================
echo "Ethernet switch version"
echo ==================================================
/usr/local/bin/switch_config_version.sh

exit 0
