#!/bin/sh

#
# This script is invoked by the spcs application on SP
#

export PATH=${PATH}:/usr/local/bin

# If no parameter was passes, simply exit

if [ -z "$1" ]
then
	exit
fi

if [ $1 == "primary" ]
then
	CMD="ipmitool -A none -H 127.0.0.1 raw 0x30 0x04 0x15 0x03 0x00 0x00"
elif [ $1 == "backup" ]
then
	CMD="ipmitool -A none -H 127.0.0.1 raw 0x30 0x04 0x15 0x03 0x00 0x01"
else
	CMD="ipmitool -A none -H 127.0.0.1 chassis power $1"
fi


if [ $1 == "status" ]
then
	$CMD | gawk -f /usr/local/bin/spcs.awk
else
	$CMD
fi
