#!/bin/sh

# sp_verbose.sh - tool to enable/disable/show verbose flag in Uboot
PATH=$PATH:/usr/local/bin
. sig_catcher

usage()
{
cat << USAGE_HERE
Usage:  sp_verbose.sh <option> [param]
       if no <option> is specified, it's used to show verbose flag.
	<option>:
		-e : Enable/Disable verbose
	[param]:
		if -e is specified,
			0: disable verbose
			1: enable verbose
USAGE_HERE
	exit 1
}

# main starts here
#
ENABLE_OPT=0
SHOW_OPT=0
RetVal=0
if [ $# -eq 0 ]; then
    SHOW_OPT=1
fi

#$1 argument is option(-e)
while getopts e verboption
do
	case $verboption in
		e)
			ENABLE_OPT=1
			;;
		*)
			usage
			;;
	esac
	shift
done


#after run "shift" command
#$1 0:disable verbose flag/Other value:enable verbose flag if -e is specified
if [ ${ENABLE_OPT} -eq 1 ]; then
	if [ $# -eq 0 ]; then
		usage
	fi
	enable=${1}
	if [ ${enable} == "0" ]; then

		#unset verbose flag
		fw_setenv verbose
		RetVal=$?
	elif [ ${enable} == "1" ]; then

		#Set verbose to true
		fw_setenv verbose true
		RetVal=$?
	else

		#Error out
		echo "Error: invalid argument"
		RetVal=1
	fi


	if [ $RetVal -eq 0 ];then
		echo "sp verbose command success"
	else
		echo "sp verbose command failure"
	fi

fi

if [ $SHOW_OPT -eq 1 ]; then

	fw_printenv verbose 2>&1 | grep true >/dev/null
	if [ $? -eq 0 ]; then
		echo "Verbose mode is enabled"
	else
		echo "Verbose mode is disabled"
	fi
	RetVal=0
fi

exit $RetVal

