#!/bin/sh
. /usr/local/bin/sig_catcher

POS=`cat /sys/class/hwmon/pos`
echo -n "POS = 0x$POS -- "
case "$POS" in
	"0") 	echo "Unexpected Reset" ;;
	"44")	echo "IPMI Service Failure" ;;
	"46")	echo "NetApp Application Failure" ;;
	"56")	echo "Power-on-Reset (normal power cycle)" ;;
	"d4")	echo "Kernel Watchdog (Timer 4) Expiration" ;;
	"d6")	echo "Uncorrectable ECC panic" ;;
	"d8")	echo "Application Watchdog (Timer 8) Expiration" ;;
	"f6")	echo "Kernel Panic" ;;
	*)	echo "Unknown" ;;
esac
