#!/bin/sh
PATH=$PATH:/usr/local/bin

. sig_catcher

	echo "system watchdog:"
	system_watchdog status
	echo

	echo -n  "Slot position: "
	slot_pos=$(gpiotool --get-data 0 10 | cut -d " " -f 3)
	if [ $slot_pos == "Low" ]; then
		echo "Slot A (top)"
	else
		echo "Slot B (bottom)"
	fi
	echo

	echo -n "Board revision: "
	rev_bit12=$(gpiotool --get-data 3 12 | cut -d " " -f 3)
	rev_bit13=$(gpiotool --get-data 3 13 | cut -d " " -f 3)
	rev_bit14=$(gpiotool --get-data 3 14 | cut -d " " -f 3)
	rev_bit15=$(gpiotool --get-data 3 15 | cut -d " " -f 3)
	echo "[$rev_bit15.$rev_bit14.$rev_bit13.$rev_bit12]"
	echo

	platform=$(cat /var/run/platform)
	echo "platform: $platform"
	exit 0
