#!/bin/sh
IPTABLES="/sbin/iptables"
IP6TABLES="/sbin/ip6tables"
TUPLE_FILE="/mnt/logs/etc/rlm_config_from_filer"
TUPLE_FILE_SPCS="/tmp/config/rlm_config_from_filer_spcs"
TUPLE_FILE_SPCS_P="/mnt/logs/etc/rlm_config_from_filer_spcs"
DEFAULT_PORT="50000"

ipv4_disable_flag=0
ipv6_disable_flag=1
spcs_port=$DEFAULT_PORT
spcs_limit_access=0
CP="/bin/cp -f"
SYNC="/bin/sync"

spcs_update_port() {

	if [ -s $TUPLE_FILE ]
	then
		tmp=`awk '/^ipv6_disable/ {print $2; exit;}' $TUPLE_FILE`
		if [ -n "$tmp" ]
		then
			ipv6_disable_flag=$tmp     
		fi

		tmp=`awk '/^ipv4_disable/ {print $2; exit;}' $TUPLE_FILE`
		if [ -n "$tmp" ]
		then
			ipv4_disable_flag=$tmp
		fi
			
		tmp=`awk '/^cluster_services_port/ {print $2; exit;}' $TUPLE_FILE`
		if [ -n "$tmp" ]
		then
			spcs_port=$tmp
		fi
	fi	
}

spcs_limit_access_get() {
	if [ -s $TUPLE_FILE ]
	then
		tmp=`awk '/^cluster_services_limit_access/ {print $2; exit;}' $TUPLE_FILE`
		if [ -n "$tmp" ]
		then
			spcs_limit_access=$tmp
		fi
	fi
}

spcs_add_rules_ipv4() {

	if [ $ipv4_disable_flag -eq 0 ]
	then
		$IPTABLES -F spcs
		if [ $spcs_limit_access -eq 0 ]
		then
			$IPTABLES -A spcs -p tcp -s 0/0 --dport $spcs_port -m limit --limit 50/s --limit-burst 50 -j ACCEPT
		else
			if [ -s $TUPLE_FILE_SPCS ]
			then
				$CP $TUPLE_FILE_SPCS $TUPLE_FILE_SPCS_P
				$SYNC
			fi

			#On boot TUPLE_FILE_SPCS may not available. So, get the list always from TUPLE_FILE_SPCS_P
			if [ -s $TUPLE_FILE_SPCS_P ]
			then
				limit_access_ips_v4=`awk '/^cluster_services_limit_access_ips_v4/ {print $2; exit;}' $TUPLE_FILE_SPCS_P`

				IFS=','

				for i in $limit_access_ips_v4
				do
					$IPTABLES -A spcs -p tcp -s $i --dport $spcs_port -m limit --limit 50/s --limit-burst 50 -j ACCEPT
				done
			fi
		fi
	fi
}

spcs_delete_rules_ipv4() {
	# Instead of deleting individual rules, we simply flush the spcs chain
	$IPTABLES -F spcs
	$IPTABLES -A spcs -p tcp -s 0/0 -j DROP
}

spcs_add_rules_ipv6() {

	if [ $ipv6_disable_flag -eq 0 ]
	then
		$IP6TABLES -F spcs
		if [ $spcs_limit_access -eq 0 ]
		then
			$IP6TABLES -A spcs -p tcp -s 0/0 --dport $spcs_port -m limit --limit 50/s --limit-burst 50 -j ACCEPT
		else
			if [ -s $TUPLE_FILE_SPCS ]
			then
				$CP $TUPLE_FILE_SPCS $TUPLE_FILE_SPCS_P
				$SYNC
			fi

			#On boot TUPLE_FILE_SPCS may not available. So, get the list always from TUPLE_FILE_SPCS_P
			if [ -s $TUPLE_FILE_SPCS_P ]
			then
				limit_access_ips_v6=`awk '/^cluster_services_limit_access_ips_v6/ {print $2; exit;}' $TUPLE_FILE_SPCS_P`
				IFS=','

				for i in $limit_access_ips_v6
				do
					$IP6TABLES -A spcs -p tcp -s $i --dport $spcs_port -m limit --limit 50/s --limit-burst 50 -j ACCEPT
				done
			fi
		fi
	fi
}

spcs_delete_rules_ipv6() {
	#Instead of deleting individual rules, we simply flush the spcs chain
	$IP6TABLES -F spcs
	$IP6TABLES -A spcs -p tcp -s 0/0 -j DROP
}

spcs_add_rules() {

	case "$2" in 
	ipv4)
		spcs_add_rules_ipv4
		;;

	ipv6)
		spcs_add_rules_ipv6
		;;
	*)
		spcs_add_rules_ipv4
		spcs_add_rules_ipv6
		;;
	esac		
}

spcs_delete_rules() {

	case "$2" in 
	ipv4)
		spcs_delete_rules_ipv4
		;;

	ipv6)
		spcs_delete_rules_ipv6
		;;

	*)
		spcs_delete_rules_ipv4
		spcs_delete_rules_ipv6
		;;
	esac
}

# The actual script execution starts here

spcs_update_port
spcs_limit_access_get

# We should add firewall rules for spcs only when spcs is running
# So, if spcs is not running, we simply exit

pidof spcs &> /dev/null || exit 0

case "$1" in
add)
	spcs_add_rules

	# We will log each time the firewall rules are added
	logger -p user.info -t spcs firewall rules added
	;;

delete)
	spcs_delete_rules

	# We will log each time the firewall rules are deleted
	logger -p user.info -t spcs firewall rules deleted
	;;

*)
	spcs_delete_rules
	spcs_add_rules

	# We will log each time the firewall rules are reloaded
	logger -p user.info -t spcs firewall rules reloaded
	;;

esac

