#!/bin/ash

. /usr/local/bin/sig_catcher

config=/tmp/eth0
config6=/tmp/eth0_6
config1=/tmp/eth1

brdrev=$(cat /var/run/boardrev)
razorl_rev_p2i=3

if [ -f "/var/run/RazorL" ] && [ "$brdrev" -lt "$razorl_rev_p2i" ] ; then
    ifconfig eth0 > $config
    ip -6 addr > $config6
    ETH0=eth0
    ifconfig eth1 > $config1
    ETH1=eth1
else
    if ifconfig eth0.32 | grep UP &> /dev/null ; then
        ifconfig eth0.32 > $config
    else
        # if eth0 has been downed, the address is still present in ifconfig
        # so filter it out now
        ifconfig eth0.32 | grep -v "inet addr" > $config
    fi
    ip -6 addr show dev eth0.32 2>/dev/null > $config6
    ETH0=eth0.32
    ifconfig eth1 > $config1
    ETH1=eth1
fi

MAC=$(awk '/HWaddr/ { print $5}' $config)
IP=$(awk '/inet addr/ {split($2, a, ":"); print a[2]}' $config)
MASK=$(awk '/Mask/ {split($4, a, ":"); print a[2]}' $config)
GW=$(route -n | awk '{if ($1 == "0.0.0.0") print $2}')
MAC1=$(awk '/HWaddr/ { print $5}' $config1)
IP1=$(awk '/inet addr/ {split($2, a, ":"); print a[2]}' $config1)
MASK1=$(awk '/Mask/ {split($4, a, ":"); print a[2]}' $config1)
GW1=$(route -n | awk '{if ($8 == "eth1") print $2}')



# caveat lector!  Notice that the link and link_pfx scripts have an "exit" after the print,
# this is so just the first match is selected from the file.
LINK=$(awk '/scope link/ {split($2, a, "/"); print a[1]; exit;}' $config6)
LINK_PFX=$(awk '/scope link/ {split($2, a, "/"); print a[2]; exit;}' $config6)
ROUTER=$(awk '/scope global dynamic $/ {split($2, a, "/"); print a[1]}' $config6)
ROUTER_PFX=$(awk '/scope global dynamic $/ {split($2, a, "/"); print a[2]}' $config6)

ipv6_ga=$(ip -o -6 addr show dev ${ETH0} scope global 2>/dev/null | grep -v "dynamic" | sed 's/  */ /g' | cut -d' ' -f 4 | head -1)
if [ -n "$ipv6_ga" ] ; then
    GLOBAL="${ipv6_ga%/*}"
    GLOBAL_PFX="${ipv6_ga#*/}"
fi

# here's the deal: depending on what the router advertises,
# it's possible to have a default route that expires, this OK in terms of ipv6, but the existing
# code here wanted default routes with no expiration date.
# This code will look for an non-expiring default route first (like the prior configuration).
# If that's not found it will look at the configuration file rlm_config_from_filer and get the default route
# and see if it matches what was requested.
GLOBAL_GW=$(ip -6 route show dev ${ETH0} | grep ^default | grep -v expires | cut -d ' ' -f 3)
if [ -z "$GLOBAL_GW" ] ; then
    if [ -s /mnt/logs/etc/rlm_config_from_filer ] ; then
        config_gateway="$(grep ^ip6_gate /mnt/logs/etc/rlm_config_from_filer | cut -f 2 -d' ')"
    fi

    if [ -n "${config_gateway}" ] ; then
        if ! ip -6 route show dev eth0 | grep ^default | grep "${config_gateway}" 2>&1 /dev/null ; then
            GLOBAL_GW="${config_gateway}"
        fi
    fi
fi

rm -f $config $config6 $config1

echo "Firmware Version:    " $(/usr/local/bin/version.sh -e -r)
echo "Mgmt MAC Address:     $MAC"
echo "Clst MAC Address:     $MAC1"
if [ -f "/var/run/RazorL" ] && [ "$brdrev" -lt "$razorl_rev_p2i" ] ; then
    # Convert all statuses to lower case to simplify matching
    ncsi0_stat=$(cat /var/run/ncsi/ports/0/operstate | sed 's/\(.*\)/\L\1/')
    ncsi1_stat=$(cat /var/run/ncsi/ports/1/operstate | sed 's/\(.*\)/\L\1/')
    if0_stat=$(cat /sys/class/net/eth0/operstate | sed 's/\(.*\)/\L\1/')
    if1_stat=$(cat /sys/class/net/eth1/operstate | sed 's/\(.*\)/\L\1/')

    if [ "$ncsi0_stat" = "up" ] && [ "$if0_stat" = "up" ]; then
        echo "Ethernet Link Eth0:  Up"
    else
        echo "Ethernet Link Eth0:  Down"
    fi

    if [ "$ncsi1_stat" = "up" ] && [ "$if1_stat" = "up" ]; then
        echo "Ethernet Link Eth1:  Up"
    else
        echo "Ethernet Link Eth1:  Down"
    fi

else
    # Convert all statuses to lower case to simplify matching
    ncsi1_stat=$(cat /var/run/ncsi/ports/1/operstate | sed 's/\(.*\)/\L\1/')
    if0_stat=$(cat /sys/kernel/switch/ports/0/linkstatus | sed 's/\(.*\)/\L\1/')
    if1_stat=$(cat /sys/kernel/switch/ports/1/linkstatus | sed 's/\(.*\)/\L\1/')
    if [ "$if0_stat" = "up" ]; then
        echo "Ethernet Link Eth0:  Up"
    else
        echo "Ethernet Link Eth0:  Down"
    fi

    if [ "$ncsi1_stat" = "up" ] && [ "$if1_stat" = "up" ]; then
        echo "Ethernet Link Eth1:  Up"
    else
        echo "Ethernet Link Eth1:  Down"
    fi

fi

if [ "$IP" = "" ] && [ "$MASK" = "" ] && [ "$GW" = "" ]; then
        echo "IPv4 configuration:   Disabled"
else
        if [ -f /var/run/udhcpc.${ETH0}.pid ]; then
                echo "  Using DHCP:         yes"
        else
                echo "  Using DHCP:         no"
        fi
        echo "IPv4 configuration:"
        echo "  IP Address Eth0:    $IP"
        echo "  Netmask Eth0:       $MASK"
        echo "  Gateway Eth0:       $GW"
        echo "  IP Address Eth1:    $IP1"
        echo "  Netmask Eth1:       $MASK1"
        echo "  Gateway Eth1:       $GW1"
fi

if [ "$GLOBAL" = "" ] && [ "$ROUTER" = "" ] && [ "$LINK" = "" ]; then
        echo "IPv6 configuration:   Disabled"
else
        echo "IPv6 configuration:"

        if [ "$GLOBAL" = "" ]; then
                echo "  Global IP:          Disabled"
        else
                echo "  Global IP:          $GLOBAL"
                echo "  Prefix Length:      $GLOBAL_PFX"
                echo "  Gateway Address:    $GLOBAL_GW"
        fi

        if [ "$ROUTER" = "" ]; then
                echo "  Router Assigned IP: Disabled"
        else
                echo "  Router IP:          $ROUTER"
                echo "  Prefix Length:      $ROUTER_PFX"
        fi

        if [ "$LINK" = "" ]; then
                echo "  Link Local IP:      Disabled"
        else
                echo "  Link Local IP:      $LINK"
                echo "  Prefix Length:      $LINK_PFX"
        fi
fi

if test $1 ; then
    if [ "$1" = "-v" ] ; then
        rlm_stats -p
    else if [ "$1" = "-d" ] ; then
            debug.sh
         fi
    fi
fi

