#!/bin/sh
PATH=$PATH:/usr/local/bin:/sbin:/usr/sbin:/usr/bin

print_config()
{
	echo "date" $(date);
	echo "ifconfig -a";
	ifconfig -a;
	echo "ip6tables -L -v";
	ip6tables -L -v;
	echo "/proc/net/dev_snmp6/eth0";
	cat /proc/net/dev_snmp6/eth0 ;
	echo "/proc/net/snmp6";
	cat /proc/net/snmp6 ;
	echo "route -A inet6";
	route -A inet6;
	echo "ip -6 route show";
	ip -6 route show;
	echo "ip -6 neigh show";
	ip -6 neigh show;
}

on_exit()
{
	print_config;
	exit 0;
}

trap "on_exit"  SIGINT SIGTERM EXIT

while ((true))
do
	for yy in $(find /proc/sys/net -type f | grep -v flush)
	do
		echo $yy $(cat $yy);
	done
	print_config;
	echo "PACKET CAPTURE STARTED";
	tcpdump -i eth0 -Q inout -p -n -s 1024 -XX -vvv ip6 or icmp6 or proto ipv6 or proto ipv6-icmp ;
	print_config;
done

exit 0;

