#!/bin/sh

this_macaddr=$(ip addr show eth0 | awk '/ether/ {print $2}' | sed 's/://g')

switch_read() {
page=$1
addr=$2
count=$3

    echo $(switch read_switchphy_BMC53101M 0 $page $addr $count)
}

switch_write() {
page=$1
addr=$2
shift 2
count=$#
data=$*

    switch write_switchphy_BMC53101M 0 $page $addr $count $data
}

print_table_entry() {
local this_addr

    if echo $* | grep -n Error ; then
        echo $*
    else
        vlan=$1
        shift 1
        macaddr=$(echo $* | sed 's/ //g')
        while [ ${#macaddr} -lt 10 ] ; do macaddr="0${macaddr}"; done
        if [ "$this_macaddr" == "00${macaddr}" ] ; then
            this_addr="(sp eth0)"
        fi
        echo -e "${vlan}\t00:${macaddr:0:2}:${macaddr:2:2}:${macaddr:4:2}:${macaddr:6:2}:${macaddr:8:2} ${this_addr}"
    fi
}

print_table_header() {
    echo -e "vlan\tmac address"
    echo -e "----\t-----------------"
}

switch_write 5 50 80 &> /dev/null

print_table_header
result=$(switch_read 5 60 4)
while [ "$result" != "0 0 0 0" ] ; do
    result2=$(switch_read 5 78 2)
    print_table_entry $result
    result=$(switch_read 5 60 4)
done


