#!/bin/sh

. /usr/local/bin/sig_catcher
i2ctest="/usr/local/bin/i2c-test"

usage() {
	echo "Usage: razor_cpld_revisions.sh --get-revision"
	echo "       razor_cpld_revisions.sh --get-ebod-rev-only"
	exit 1
}


# Allow 1 parameter --get-revision
# anything other input should print out usage help
if [ $# -gt 1 ] || [ $# = 0 ] ; then
	usage
	exit 1
fi

addr=0xb0
chip_name="ebod"

$i2ctest -sbd -b 3  -ms ee -mc 20 -s $addr -rc 1 -w -d 0 
design_id=$($i2ctest   -b 3 -ms ee -mc 20 -s $addr -r -rc 1 | head -2 |tail -1|cut -c1-2)
$i2ctest -sbd -b 3 -ms ee -mc 20 -s $addr -rc 1 -w -d 1
chip_num=$($i2ctest -b 3 -ms ee -mc 20 -s $addr -r -rc 1 | head -2 |tail -1|cut -c1-2)
$i2ctest -sbd -b 3 -ms ee -mc 20 -s $addr -rc 1 -w -d 2
rev_maj=$($i2ctest -b 3 -ms ee -mc 20 -s $addr -r -rc 1 | head -2 |tail -1|cut -c1-2)
rev_maj=$(printf "%d" 0x$rev_maj)
$i2ctest -sbd -b 3 -ms ee -mc 20 -s $addr -rc 1 -w -d 3
rev_min=$($i2ctest -b 3 -ms ee -mc 20 -s $addr -r -rc 1 | head -2 |tail -1|cut -c1-2)
rev_min=$(printf "%d" 0x$rev_min)

if [ $# = 1 ] && [ $1 = --get-revision ] ; then
	echo "design_id:$design_id"
	echo "chip_num:$chip_num"
	# tuple format used by collect_fw_vers.sh
	echo "fw_rev_$chip_name $rev_maj.$rev_min"
elif [ $# = 1 ] && [ $1 = --get-ebod-rev-only ] ; then
	echo "$chip_name: $rev_maj.$rev_min"
else
	echo "Unsupported option: $1"
	usage
fi

