#!/bin/sh
. /usr/local/bin/sig_catcher

if [ -f /var/run/Absolut ]; then
	port80=`/usr/local/bin/agentlite raw 2 0xae 0xa8 1 2 | grep a8 | sed -e 's|a8 ||' -e 's| *$||'`
else
	port80=`cat /sys/class/hwmon/port80`
fi
bbsp=`cat /sys/class/hwmon/bbsp`

echo -n "Port 0x80 = 0x$port80 -- "
if [ $bbsp == "2f" ] ; then
	echo "ONTAP is running"
	exit 0
else if [ $bbsp == "20" ] || [ $bbsp == "21" ] || [ $bbsp == "22" ] ; then
		echo "Bootloader is running - not applicable";
		exit 0;
	fi
fi

case "$port80" in
	"01")	echo "Initialize IPMI" ;;
	"02")	echo "Verify real mode" ;;
	"03")	echo "Disable NMI" ;;
	"04")	echo "Get CPU type  " ;;
	"06")	echo "Initialize system hardware" ;;
	"07")	echo "Disable shadow ROM and execute ROMEXEC code from flash " ;;
	"08")	echo "Initialize chipset with initial POST values" ;;
	"09")	echo "Set  InPost Flag" ;;
	"0a")	echo "Initialize Cpu's" ;;
	"0b")	echo "Turn On Cache" ;;
	"0c")	echo "Init Cache" ;;
	"0e")	echo "Init IO" ;;
	"0f")	echo "Initialize Fdisk" ;;
	"10")	echo "Initialize PM" ;;
	"11")	echo "Init Registers" ;;
	"12")	echo "Restore the contents of the CPU control word whenever the CPU is reset." ;;
	"13")	echo "Reset PCI devices in early POST." ;;
	"14")	echo "Initialize Keyboard Controller" ;;
	"16")	echo "Test checksum" ;;
	"17")	echo "Shutdown system." ;;
	"17")	echo "Size up RAM" ;;
	"18")	echo "8254 timer initialization" ;;
	"1a")	echo "Initialize DMA" ;;
	"1c")	echo "Reset PIC" ;;
	"20")	echo "Refresh" ;;
	"22")	echo "Test Keyboard Controller" ;;
	"24")	echo "Set ES segment register to 4GB" ;;
	"28")	echo "Size Ram" ;;
	"29")	echo "Initialize the POST Memory Manager" ;;
	"2a")	echo "Zero the base" ;;
	"2b")	echo "Initialize Enhanced CMOS" ;;
	"2c")	echo "Address test" ;;
	"2e")	echo "Base Ram" ;;
	"2f")	echo "Pre Shadow System Ram" ;;
	"32")	echo "Compute the CPU clock speed" ;;
	"33")	echo "Initialize the Phoenix Dispatch Manager" ;;
	"34")	echo "Test the CMOS RAM and RTC" ;;
	"38")	echo "Shadow Sys mem" ;;
	"3a")	echo "Autosize Cache" ;;
	"3b")	echo "Init DbgSvr" ;;
	"3c")	echo "Common Chipset Advanced Configuration" ;;
	"3d")	echo "Advanced Register Configuration" ;;
	"42")	echo "Initialize Vectors" ;;
	"45")	echo "POST device initialization" ;;
	"46")	echo "Display Copyright" ;;
	"48")	echo "Verify the hardware configuration" ;;
	"49")	echo "Initialize PCI bus and devices" ;;
	"4a")	echo "Initialize all video adapters in system" ;;
	"4b")	echo "Quiet boot start" ;;
	"4c")	echo "Shadow video BIOS ROM" ;;
	"4e")	echo "Display BIOS copyright notice" ;;
	"4f")	echo "Allocate memory for multiboot data" ;;
	"50")	echo "Display CPU type and speed" ;;
	"51")	echo "Initialize EISA board" ;;
	"52")	echo "Initialize and Configure the Keyboard & PS/2 Mouse" ;;
	"54")	echo "Initialize keystroke clicker during POST" ;;
	"55")	echo "Initialize USB" ;;
	"58")	echo "Test for unexpected interrupts" ;;
	"59")	echo "Initialize POST display service" ;;
	"5a")	echo "Display prompt" ;;
	"5b")	echo "Disable CPU cache" ;;
	"5c")	echo "Test RAM between 512 and 640KB" ;;
	"60")	echo "Test extended memory" ;;
	"62")	echo "Test external memory address lines" ;;
	"64")	echo "Jump to user patch 1" ;;
	"66")	echo "Configure advanced cache registers" ;;
	"67")	echo "Initialize minimum MP Table" ;;
	"68")	echo "Enable external and CPU caches" ;;
	"69")	echo "Setup the SMM handler" ;;
	"6a")	echo "Display external L2 cache size" ;;
	"6b")	echo "Set Custom Defaults" ;;
	"6c")	echo "Display shadow area message" ;;
	"70")	echo "Display error messages" ;;
	"72")	echo "Check for configuration errors" ;;
	"76")	echo "Report if there was a Keyboard or Controller failures" ;;
	"7c")	echo "Setup h/w interrupt vectors" ;;
	"7d")	echo "Initialize Intelligent System Monitoring." ;;
	"7e")	echo "Coprocessor initialization test" ;;
	"80")	echo "Disable onboard super I/O ports and IRQ's" ;;
	"81")	echo "Late POST device initialization" ;;
	"82")	echo "Detect and install external RS232 ports" ;;
	"83")	echo "Configure non MCD IDE controllers" ;;
	"84")	echo "Detect and install external parallel ports" ;;
	"85")	echo "Initialize PC-compatible PnP ISA devices" ;;
	"86")	echo "Re-initialize onboard I/O ports" ;;
	"87")	echo "Configure motherboard configurable devices" ;;
	"88")	echo "Initialize BIOS data area" ;;
	"89")	echo "Enable non-maskable interrupts" ;;
	"8a")	echo "Initialize extended bios data area" ;;
	"8b")	echo "Test and initialize PS/2 mouse" ;;
	"8c")	echo "Initialize floppy controller" ;;
	"8f")	echo "Determine number of ATA drives" ;;
	"90")	echo "Initialize hard disk controllers" ;;
	"91")	echo "Initialize local bus hard disk controllers" ;;
	"92")	echo "Jump to user patch 2" ;;
	"93")	echo "Build MPTBLE for multi-processor boards" ;;
	"95")	echo "Install CD ROM for boot" ;;
	"96")	echo "Exit big real mode." ;;
	"97")	echo "Fixup multi processor table" ;;
	"98")	echo "Search for option ROMs." ;;
	"99")	echo "Check for SMART drive" ;;
	"9b")	echo "Pm CPU Speed" ;;
	"9c")	echo "Setup Power Management" ;;
	"9d")	echo "Initialize security" ;;
	"9e")	echo "Enable hardware interrupts" ;;
	"9f")	echo "Determine number of ATA and SCSI drives" ;;
	"a0")	echo "Set time of day" ;;
	"a2")	echo "Check key lock" ;;
	"a4")	echo "Initialize typematic rate" ;;
	"a8")	echo "Erase F2 prompt" ;;
	"aa")	echo "Scan for F2 key stroke" ;;
	"ac")	echo "Enter SETUP" ;;
	"ae")	echo "Clear boot flag" ;;
	"b0")	echo "Check for errors" ;;
	"b2")	echo "POST done, prepare to boot operating system" ;;
	"b3")	echo "Store enhanced CMOS values in non-volatile area" ;;
	"b5")	echo "Terminate quietboot" ;;
	"b6")	echo "Check password" ;;
	"b7")	echo "Setup ACPI tables in shadow RAM and extended memory" ;;
	"b9")	echo "Prepare boot" ;;
	"ba")	echo "Initialize DMI parameters" ;;
	"bc")	echo "Clear parity checkers" ;;
	"bd")	echo "Display multi boot menu" ;;
	"be")	echo "Clear screen" ;;
	"bf")	echo "Check virus and backup reminders" ;;
	"c0")	echo "Try to boot OS with INT19" ;;
	"c1")	echo "Initialize PEM data structures" ;;
	"c2")	echo "Initialize error logging" ;;
	"c3")	echo "Initialize error display functions" ;;
	"c4")	echo "Initializes (clears) the system error flags" ;;
	"c4")	echo "Set IRQ1 and INT15 vectors" ;;
	"c5")	echo "Clear flag to indicate we are no longer in POST" ;;
	"c5")	echo "Docking Pnp support check" ;;
	"c6")	echo "Docking support check" ;;
	"c6")	echo "Initialize note dock" ;;
	"c7")	echo "Remove display manager and INT10 hook" ;;
	"c8")	echo "Force checksum" ;;
	"c8")	echo "Test A20 Line" ;;
	"c9")	echo "Early EISA extended DMA controller  test" ;;
	"c9")	echo "Extended checksum" ;;
	"ca")	echo "Late EISA extended DMA controller test" ;;
	"cb")	echo "Save memory config" ;;
	"cc")	echo "Serial Video init" ;;
	"cd")	echo "Reclaim console vector after HW vectors initialized" ;;
	"ce")	echo "Pen Init " ;;
	"d1")	echo "Initialize the Bios Stack" ;;
	"d3")	echo "Setup the WAD" ;;
	"d4")	echo "Get CPU String" ;;
	"d5")	echo "Switch POST table to compatSegment." ;;
	"d7")	echo "Check Firstware" ;;
	"d8")	echo "ASF init" ;;
	"d9")	echo "Perform any ipmi init late in post" ;;
	"da")	echo "Initialize PCI Express" ;;
	"db")	echo "SROM Test" ;;
	"dc")	echo "Update Check Error" ;;
	"e1")	echo "Periodic Timer" ;;
	"e2")	echo "Phoenix security key test" ;;
	"e5")	echo "Initialize WHEA" ;;
	*)		echo "Unknown" ;;
esac
