#!/bin/ash
brdrev=$(cat /var/run/boardrev)
razorl_rev_p2i=3

#Query NC-SI interface to ensure latest status is available
/usr/local/bin/ncsi_cmd eth1 0 0 a

link_status=0

if [ -f /var/run/RazorL ] && [ "$brdrev" -lt "$razorl_rev_p2i" ] ; then
    /usr/local/bin/ncsi_cmd eth0 0 0 a
    ncsi0_stat=$(cat /var/run/ncsi/ports/0/operstate)
    if0_stat=$(cat  /sys/class/net/eth0/operstate)

    if  [ "$ncsi0_stat" = "Up" ] && [ "$if0_stat" = "up" ]; then
        link_status=1
    fi

else
    #WRENCH PORT is port 0 in Razor
    link_status=$(/usr/local/bin/switch link 0 | grep -c "Up");
fi

if [ "$link_status" -eq 1 ]; then
	echo "Up";
	exit 1;
else
	exit 0;
fi
