PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
#set -x
pkg=0; chan=0;
ncsi_cmd="/usr/local/bin/ncsi_cmd"
ncsi_status_file_0="/var/run/ncsi/ports/0/operstate"
ncsi_status_file_1="/var/run/ncsi/ports/1/operstate"
valid=0
output=0

#validate interface name
case "$1" in
	eth0) 
	    status_file=$ncsi_status_file_0
	    valid=1     
	    ;;
	eth1) 
	    status_file=$ncsi_status_file_1
	    valid=1
	    ;;
	*) 
    	echo "$1 - Unknown/Invalid interface"
    	valid=0
	    ;;
esac

#if interface is valid, then check for link status file, and then send NC-SI packet and validate response.
if [ $valid == 1 ]; then
	echo "Interface is valid"
	if [ -s $status_file ]; then
		echo "Status file found"
		state=$(cat $status_file)
		if [ $state == "Up" ] ; then
			echo "Status is Up"
			output=$( $ncsi_cmd $1 $pkg $chan 0A | grep -c SerDes)
			if [ $output == 1 ]; then
				echo "$1 is Up and NC-SI is working"
			else
				echo "$1 is Up but NC-SI is not working.  Try running ncsi config"
			fi
    	else
			echo "$1 is Down"
    	fi
    else
        echo "$1 is Down"       
    fi
fi



