#!/bin/sh
PATH=$PATH:/usr/local/bin:/sbin:/usr/sbin:/usr/bin

IPV6_ND_LOCK_DIR="/tmp/ipv6_nd_lock_dir"
IPV6_ND_DEBUG="/tmp/ipv6_nd_lock_dir/debug"
DEVICE_NAME="eth0"

on_exit()
{
	rm -rf $IPV6_ND_LOCK_DIR
}

# Neighbor dicover
ipv6_nd() {
	local cnt=0
	local retval=-1
	local ip6addr
	if [ -s /mnt/logs/etc/rlm_config_from_filer ] ; then
		while [  "$cnt" -lt 20  -a "$retval" -ne 0 ]
		do
			#IP6 address may change during running this script file. Get the latest IP6 address from this file for every loop.
			ip6addr=$(grep ip6_addr < /mnt/logs/etc/rlm_config_from_filer | cut -d ' ' -f 2)
			echo "IPv6_ND addr: $cnt, $ip6addr" > $IPV6_ND_DEBUG
			if [ -n "$ip6addr" ] ; then
				#Notify all nodes that network information is updated via device and new address interface
				ping6 -c 2 -I $DEVICE_NAME ff02::1 > /dev/null
				ping6 -c 2 -I $ip6addr ff02::1 > /dev/null
				sleep 15
				#Check if it can get response from routers. if so, exit the loop, if not, try again.
				ping6 -c 2 -I $ip6addr ff02::2 > /dev/null
				retval=$?
				cnt=$((cnt+1))
				sleep 2
			else
				break
			fi
		done
		if [ "$cnt" -ge 20 -a "$retval" -ne 0 ] ; then
			logger -t ipv6_nd.sh "No response from routers, check if ping6 SP_IPv6_addr command works in the client, if not, please reconfigure SP IPv6."
		fi
	fi
}

# Main() start
brdrev=$(cat /var/run/boardrev)
razorl_rev_p2i=3
if [ -f /var/run/RazorS ] || [ -f /var/run/RazorM ] || [ -f /var/run/RazorL -a "$brdrev" -ge "$razorl_rev_p2i" ] ; then
        DEVICE_NAME="eth0.32"
fi

#Create a lock, the lock is cleaned in on_exit() when script exits
mkdir $IPV6_ND_LOCK_DIR
if [ $? -ne 0 ]; then
	#The script file is running now.
	exit 0;
fi
trap "on_exit" SIGINT SIGTERM EXIT

ipv6_nd
exit 0;



