#!/bin/ash
. /usr/local/bin/ipmi.env

IPMITOOL_GET_SENSOR_EXTENSION="sensor get"
THRESH_LONG_STRING=""
RE=""

if [ $# != 2 ]
then
	echo "Usage: get_sensor_threshold.sh <sensor_name> <threshold>"
	echo "Valid threshold inputs: lnr, lcr, lnc, unc, ucr, unr"
else
	VAR=`$IPMITOOL_EXEC $IPMITOOL_GET_SENSOR_EXTENSION $1`

	if [ "$2" == "lnr" ]
	then
		THRESH_LONG_STRING="Lower Non-Recoverable"
	fi
	if [ "$2" == "lcr" ]
	then
		THRESH_LONG_STRING="Lower Critical"
	fi
	if [ "$2" == "lnc" ]
	then
		THRESH_LONG_STRING="Lower Non-Critical"
	fi
	if [ "$2" == "unc" ]
	then
		THRESH_LONG_STRING="Upper Non-Critical"
	fi
	if [ "$2" == "ucr" ]
	then
		THRESH_LONG_STRING="Upper Critical"
	fi
	if [ "$2" == "unr" ]
	then
		THRESH_LONG_STRING="Upper Non-Recoverable"
	fi

	echo $VAR | sed -e "s/.*$THRESH_LONG_STRING[[:space:]]*:[[:space:]]*\(-\?[[:digit:]]*\.[[:digit:]]*\|na\).*/\1/"
fi
