#!/bin/sh
PATH=$PATH:/usr/local/bin:/sbin:/usr/sbin
. sig_catcher

openssh_fips_handle()
{
	#Copy default ssh config and Stop SSH daemon
	cp /etc/ssh/sshd_config.default /etc/ssh/sshd_config
	/usr/sbin/sshd -T -C user=$LOGNAME -C host=localhost -C addr=localhost > /dev/null 2>&1

	if [ -f "/tmp/sp_ssh_algo.conf" -a $? -eq 0 ]
	then
		sel_logger SP.notice "fips_handler.sh reloading sshd"
		/etc/init.d/ssh_bg stop
		#Start SSHD daemon
		/etc/init.d/ssh_bg start
	fi
	sel_logger SP.notice "fips_handler.sh: restart sshd by ssh_bg"
	/usr/local/bin/ssh_config_prereload.sh &
}


# Main() start
openssh_fips_handle


