#!/bin/sh
PATH=$PATH:/usr/local/bin
#set -x

usage() {
    echo "command fan_num"
    echo "command <version | reset | update>"
    exit 1
}

check_fan_ctrl() {
      if [ $1 -ne 11 ] && [ $1 -ne 12 ] &&
         [ $1 -ne 21 ] && [ $1 -ne 22 ] &&
         [ $1 -ne 31 ] && [ $1 -ne 32 ]; then
            echo "<fan controller - 11,12,21,22,31,32>"
            exit 1
      fi
}

check_fan_module() {

      if [ $1 -lt 1 ] || [ $1 -gt 3 ]; then
        echo "<fan module - 1 2 3>"
        exit 1
      fi
}

check_number() {
if ! [ $1 -eq $1  2> /dev/null ]; then
    echo "Argument is not a number!"
    usage
fi
}

# Start here
if [ $# -ne 2 ]; then
    echo "Invalid number of arguments"
    usage
fi

platform=$(cat /var/run/platform)
command=$1
fan_num=$2

### Make sure those are legitimate arguments
# $fan_num is always a number - fan module or fan controller
check_number $fan_num
if [ $command == "version" ]; then
    check_fan_ctrl $fan_num
    fan_controller $fan_num version
fi
if [ $command == "reset" ]; then
    check_fan_ctrl $fan_num
    fan_controller $fan_num reset
fi
if [ $command == "update" ]; then
    check_fan_module $fan_num
    update_fan_firmware.sh -f $fan_num
fi

