#!/bin/sh

PATH=$PATH:/usr/local/bin
ACP_CMD_OUTPUT_FILE="/tmp/acp_sensor_command_output.txt"
NUM_RETRIES=15

SUCCESS=0
COUNT=0

while [ "$SUCCESS" -eq 0 ];
do
	if [ "$COUNT" -ge "$NUM_RETRIES" ]
	then
		echo "Command Failed"
		rm -f $ACP_CMD_OUTPUT_FILE
		exit 1
	fi

	ipmi oem acp $1 $2 > $ACP_CMD_OUTPUT_FILE
	# Look for strings like this: (err : messaging error)
	if grep -Fq \(err $ACP_CMD_OUTPUT_FILE
	then
		SUCCESS=0
		sleep 1
	else
		SUCCESS=1
	fi

	COUNT=$((COUNT+1))
done

echo "$(cat $ACP_CMD_OUTPUT_FILE)"
rm -f $ACP_CMD_OUTPUT_FILE
