#!/bin/sh
if [ $1 == "55" ]
then
	echo "Self Test Passed status: $1 $2"
else
	echo "Self Test Failed status: $1 $2"
case "$1" in
	"56")	echo "Function not implemented" ;;
	"57")	echo "Corrupted or inaccessible data or devices" 
		if let "0x$2 & 0x1"
		then
			echo "controller operational firmware corrupted" 
		fi
		if let "0x$2 & 0x2"
		then
			echo "controller update 'boot block' firmware corrupted" 
		fi
		if let "0x$2 & 0x4"
		then
			echo "Internal Use Area of BMC FRU corrupted" 
		fi
		if let "0x$2 & 0x8"
		then
			echo "SDR Repository empty"
		fi
		if let "0x$2 & 0x10"
		then
			echo "IPMB signal lines do not respond"
		fi
		if let "0x$2 & 0x20"
		then
			echo "Cannot access FRU device"
		fi
		if let "0x$2 & 0x40"
		then
			echo "Cannot access SDR Repository"
		fi
		if let "0x$2 & 0x80"
		then
			echo "Cannot access SEL device"
		fi
		;;	
	"58")	echo "Fatal hardware error" ;;
	"60")	if [ -f "/var/run/RazorS" ] || [ -f "/var/run/RazorM" ]; then
			echo "ACP self-test failure" 
			if let "0x$2 & 0x01" ; then
				echo "CPLD interface test failed"
			fi
			if let "0x$2 & 0x02" ; then
				echo "expander ethernet interface test failed"
			fi
		else
			echo "Unknown error"
		fi
		;;
	*)	echo "Unknown error" ;;
esac
fi

