#!/bin/sh
. /usr/local/bin/sig_catcher

platform=$(cat /var/run/platform)
readcount=32
headcount=3
tailcount=2
case $platform in
	RazorL|RazorM|RazorS)
	for val in `/usr/local/bin/i2c-test -b 5 -s 0xa8 -rc $readcount -m 1 -d 0|head -n $headcount|tail -n $tailcount`; do
		if [ $val !=  "00" ] && [ $val != "ff" ]; then
			echo $((0x$val)) | awk '{printf "%c",$1}'
		else
			echo -n " "
		fi
	done
	;;
	*)
		echo "This feature is not supported in ${platform:-unknown platform}"
	;;
esac

echo ""
