#!/bin/sh
#
# Consolidate messages and debug logs into /tmp/summary_logs.txt for ASUP use
#
. /usr/local/bin/sig_catcher

#
# Log base directory
#
logdirbase="/var/log"

print_log_name()
# $1: file
{
	echo
	echo "#" 
	echo "# cat $1"
	echo "#"
}



#
# Main starts here
#

if [ -f "$temp_file" ] ; then

	rm -f $temp_file

fi

for logfile in messages.1 messages debug.1 debug
do
	lfile="$logdirbase/$logfile"	

	if [ -f "$lfile" ] ; then

		print_log_name $lfile
		cat $lfile
	fi
done

