#!/bin/sh
#
# Put adapter configuration code in the same place for manually configured adapters
#  eth0.32 will be configured in /etc/network/interfaces
#

action=''
interface=''
reset=0
inet_address=''
inet_mask=''
multicast_target=''
multicast_netmask=''
bootp_server_addr=''

echo "$*" >> /var/log/network-conf

# what slot are we in?  we'll use this to configure the adpaters later
# in the script
if /usr/local/bin/gpiotool 0 10 --get-data | grep High &> /dev/null ; then
    slot=2
else
    slot=1
fi

eth0_up() {
    ifconfig eth0 0.0.0.0 mtu 1400 up
    ifconfig eth0 fec0::1/64 up
    vconfig add eth0 32
    vconfig add eth0 16
    vconfig add eth0 64
}

eth0_down() {
    ifdown eth0.16
    ifdown eth0.32
    ifdown eth0.64 
    vconfig rem eth0.32
    vconfig rem eth0.16
    vconfig rem eth0.64
    ifconfig eth0 down
}

down_adapter() {
local adapter
local table

    adapter=${1}
    table=${2}

    [ -z "${adapter}" ] || [ -z "$table" ] && return 1

    ip link set ${adapter} down
    ip route show | grep ${adapter} | while read r ; do
        route del ${r} 
    done
    ip route flush table ${table}
    ip address flush dev ${adapter}
    ip rule del iif ${adapter} table ${table}

}

eth0_16_up() {

local hw_route 

    [ -n "${reset}" ] && ip -4 addr del dev eth0.16

    ip address add ${inet_address:-192.0.2.80}/${inet_mask:-24} dev eth0.16

    if ! ip link show eth0.16 | grep UP &> /dev/null ; then
        ip link set eth0.16 up
    fi
    [ -f /proc/sys/net/ipv6/conf/eth0.16/disable_ipv6 ] && (echo 1 > /proc/sys/net/ipv6/conf/eth0.16/disable_ipv6)
    ip route show | grep eth0.16 | while read hw_route ; do 
        ip route del ${hw_route}
        ip route add ${hw_route} table 16
    done
    ip route add ${inet_address:-192.0.2.80} dev eth0.16 table 16
    ip route add ${inet_address:-192.0.2.83} dev eth0.16 table 16
 
    [ -n ${bootp_server_addr} ] && ip route add ${bootp_server_addr} dev eth0.16 table 16
    
    if ! ip rule show | grep "lookup 16" &> /dev/null ; then 
        ip rule add iif eth0.16 table 16
    fi
 
    # we need this route so that ARP replies happen correctly
    ip route add ${inet_address:-192.0.2.80} dev eth0.16 scope host
    ip route add ${inet_address:-192.0.2.83} dev eth0.16 scope host

    echo 0 > /proc/sys/net/ipv4/conf/eth0.16/rp_filter
    echo 1 > /proc/sys/net/ipv4/conf/eth0.16/arp_ignore

}

eth0_16_down() {

    down_adapter eth0.16

}

eth0_64_up() {

local hw_route 

    greenip=$((${slot}+3))
    ebodip=$((${slot}+1))

    [ -n "${reset}" ] && ip -4 addr del dev eth0.64

    # configure the adapter
    ip address add ${inet_address:-10.1.1.${greenip}}/${inet_mask:-24} dev eth0.64
    ip link set eth0.64 up
    [ -f /proc/sys/net/ipv6/conf/eth0.64/disable_ipv6 ] && (echo 1 > /proc/sys/net/ipv6/conf/eth0.64/disable_ipv6)
    ip route show | grep eth0.64 | while read hw_route ; do 
        ip route del ${hw_route}
        ip route add ${hw_route} table 64
    done
	ip route add ${inet_address:-10.1.1.${greenip}} dev eth0.64 table 64
    ip route add ${inet_address:-10.1.1.${ebodip}} dev eth0.64 table 64

    echo 0 > /proc/sys/net/ipv4/conf/eth0.64/rp_filter
    echo 1 > /proc/sys/net/ipv4/conf/eth0.64/arp_ignore
    ip rule add iif eth0.64 table 64

    #Tag the traffic with highest priority 7 by VLAN tagging
    vlan_qos=7
    for skb_prio in $(seq 0 7) ; do
        vconfig set_egress_map eth0.64 $skb_prio $vlan_qos
    done

}

eth0_64_down() {

    down_adapter eth0.64 64

}

while getopts "rd:m:i:a:vc:t:s:w:" f ; do 
    case $f in 
        i)
            interface="${OPTARG}"
        ;;    
        a)
            action="${OPTARG}"
        ;;    
        d)
            inet_address="${OPTARG}"
        ;;
        m)
            inet_mask="${OPTARG}"
        ;;
        r)
            reset=1
        ;;
        c)
            multicast_netmask=${OPTARG}
        ;;
        t)
            multicast_target=${OPTARG}
        ;;
        v)
            set -x
        ;;
        s)
            bootp_server_addr=${OPTARG}
        ;;
        w)
            echo "configuring from ${OPTARG}"
        ;;
    esac    
done
    

if [ -z "$interface" ] ; then 
    echo "must supply an interface via -i"
    exit 1
fi

if [ -z "$action" ] ; then
    echo "must supply an action (up, down) via -a"
    exit 1
fi

func="${interface//./_}_${action}"

if type -t ${func} > /dev/null ; then
    ${func} 
else
    echo "nothing to do for ${func}"
fi

