#!/bin/sh


#
# Temporary file name
#
unique=$$
temp_file="/tmp/fw_vers_temp$unique"


#
# Firmware revision key used by the tuple
#
key_cntlr_agent="fw_rev_cntlr_agent"
key_cntlr_switch="fw_rev_cntlr_switch"
key_fan="fw_rev_mpc_fan"
key_support_fpga="fw_rev_support_fpga"
cleanup_exit()
#$1: exit code
{
        local exit_val=$1

        rm -f $temp_file
        exit $exit_val
}

#
# Signal handler, for when the user presses ctrl-c or the process gets a shutdown signal
#
handlesignal() {

    echo "**ctrl-c pressed, stopping**"
        cleanup_exit 1

        trap "echo ctrl-c already pressed, stopping in progress " SIGHUP SIGINT SIGTERM
}

# enable the above signalhander
trap handlesignal SIGHUP SIGINT SIGTERM

get_fan_ver()
{
    #
    # Fan version
    #
    #check if FAN FRU is present

    event_signal_status0=$(/usr/local/bin/supportfpgatool --mem-read ESSR0)

    idx_str="11 12 21 22 31 32"

    for idx in ${idx_str}
    do
        # Monitoring bits on ESSR: 
        #   ESSR0:[16-18] (fan_present_n);
        case ${idx} in 
            11|12)
                fan_present_n=0x$(echo $event_signal_status0 | cut -c 6)
                fan_present_n=$(($fan_present_n & 0x1))
                ;;
            21|22)
                fan_present_n=0x$(echo $event_signal_status0 | cut -c 6)
                fan_present_n=$(($fan_present_n & 0x2))
                ;;
            31|32)
                fan_present_n=0x$(echo $event_signal_status0 | cut -c 6)
                fan_present_n=$(($fan_present_n & 0x4))
                ;;
            *)
                ;;
        esac
        if [ $fan_present_n -ne 0 ]; then
            if [ ${idx}==11 -o ${idx}==12 -o ${idx}==21 -o ${idx}==22 -o ${idx}==31 -o ${idx}==32 ]; then
                data2="FAN-is-not-present"
            fi
        else            
            filename="/var/run/fan"${idx}".version"
            if [ -f $filename ]
            then
                fan_rev=$(cat $filename | grep Version: | sed -e 's/FC//g' | cut -d " " -f 2)
            else
                # Sleep and recreate the file 
                sleep 5
                fan_rev=$(fan_cmds.sh version $idx | grep Version: | sed -e 's/FC//g' | cut -d " " -f 2)
            fi
            if [  $? -eq 0 ];then
                data2=$fan_rev
            else
                data2="unknown"
            fi
        fi
        echo "$key_fan$idx $data2"
    done
}

get_ethswitch_ver()
{
    #
    # controller switch
    #
    #echo "cat /var/run/switch_version_controller"
    temp_file2=$(/usr/local/bin/switch_config_version.sh 0 2>/dev/null)
    echo $temp_file2 | sed 's/ /-/g' > $temp_file
    read data1 < $temp_file
    echo "$key_cntlr_switch $data1"
}

get_pcieswitch_ver()
{
    #
    # PCIe switch
    #
    for id in ${pcieswitch_ids}
    do
        pcieswitch_rev=$(/usr/local/bin/pcieswitch_eeprom.sh version $id 2> /dev/null)
        if [ $? -ne 0 ];then
            echo "unknown" > $temp_file
        else
            echo $pcieswitch_rev > $temp_file
        fi
        read data1 data2 < $temp_file
        echo "pcie_switch-$id: $data1"
        sleep 1
    done
}

get_fpga_ver()
# $1 key name
# $2 tool name
# $3 device
{
    full_rev=$(/usr/local/bin/supportfpgatool --get-revision)
    echo fpga: $full_rev
}

get_cpld_version()
{
    full_rev=$(/usr/local/bin/razor_cpld_revisions.sh --get-ebod-rev-only)
    echo "$full_rev"
}

get_device_version()
# $1: device
{
    case ${1} in
        eth_switch)
            get_ethswitch_ver
            ;;
        pcie_switch)
            get_pcieswitch_ver      
            ;;
        fan)
            get_fan_ver
            ;;
        support_fpga)
            get_fpga_ver
            ;;
        ebod)
            get_cpld_version
            ;;
        *)
            #Please don't output error messages because they are captured in "rlm_config_to_filer"
            #for ONTAP consumption. The error messages are not tuples format.
            exit 1
            ;;
    esac
}
#

#
# Main starts here
#

platform=$(cat /var/run/platform)
brdrev=$(cat /var/run/boardrev)
razorl_rev_p2i=3
case $platform in
    RazorL)
        pcieswitch_ids="0 1"
        components="fan support_fpga pcie_switch"
        if [ $brdrev -ge $razorl_rev_p2i ] ; then
            components="eth_switch $components"
        fi

        for device in ${components}
        do
            get_device_version $device
        done
        ;;
    RazorM|RazorS)
        pcieswitch_ids="1"
        components="eth_switch support_fpga pcie_switch ebod"
        for device in ${components}
        do
            get_device_version $device
        done
        ;;
    *)
        echo "Command not supported on this platform"
        exit 1
        ;;
esac

rm -f $temp_file

