#!/bin/sh

PATH=$PATH:/usr/local/bin

. sig_catcher

brd_rev=$(cat /var/run/boardrev)
razorm_rev_p1b=2

find_default_file()
#$1 : device
#$2 : id
{
	local retval=0
	local fpga_pwd=""
	local dev=${1}
	local id=${2}
	case $dev in
		pcie_switch)
			if [ "RazorL" == $platform ]; then
				filename_pre="FASRAZL"
			elif [ "RazorM" == $platform ]; then
				filename_pre="FASRAZM"
			fi

			# find default file in /firmware/${platform}/pcieswitch
			filename=$(ls /firmware/${platform}/pcieswitch/${filename_pre}*_*${id}_*.bin 2>/dev/null)
			;;

		eth_switch)
			# find default file in /firmware/${platform}/pcieswitch
			filename=$(ls /firmware/${platform}/switch/*.txt 2>/dev/null)
            ;;
		fan)
			#find the comtroller image of fan device
			filename=$(ls /firmware/$platform/fan/fan_firmware_*.mot | grep -v "boot" 2>/dev/null)
			;;
		support_fpga)
			if [ "$dev" = "support_fpga" ]; then
				subdir_name="fpga"
			else
				subdir_name=$dev;
			fi
			fpga_pwd="/firmware/$platform/$subdir_name"
			filename=$(ls $fpga_pwd/*.bin 2>/dev/null | cut -d / -f 5 | cut -d . -f 1,2 | sed -e s/[^0-9.]//g)
			;;
		ebod)
			if [ $brd_rev -ge $razorm_rev_p1b ] ; then
				filename=$(ls /firmware/RazorM/ebod/*.jam | grep -v RazorM_ebod_rev_0.6.jam 2>/dev/null)
			else
				filename=$(ls /firmware/RazorM/ebod/RazorM_ebod_rev_0.6.jam 2>/dev/null)
			fi

			;;
		ddr_eeprom)
			filename=$(ls /firmware/$platform/ddr/*.txt 2>/dev/null | cut -d / -f 5 | cut -d _ -f 6 | sed -e s/[^0-9]//g)
			;;

		*)
			;;
	esac

	if [ "$filename" == "" ]; then
			retval=1
	fi
	return $retval
}
check_power_status()
#1 : device
{
	#retval: 0: status is OK, 1: status is bad.
	#For battery, pcie_switch devices,it needs to check power status.
	#For other device, staut is always OK.

	local retval=0
	local power_status=0
	local dev=${1}
	local message="Host off: skip checking $dev rev"
	power_status=$(agentlite power status | cut -d : -f 2)
	case $dev in
			pcie_switch)
			    if [ 0 -eq ${power_status} ]; then
					echo "$message"
					retval=1
				fi
				;;
			*)
				;;
	esac
	return $retval
}

compare_revision()
# $1: device_revision
# $2: device
# $3: id
{
	local file_rev=""
	local device_rev=${1}
	local dev=${2}
	local id=${3}
	local message1="Img not found:skip checking ${dev}${id} rev"
	local message2=""
	local retval=0
	local result=0
	case $dev in
			battery)
				file_rev=$(batTool image_rev)
				result=$?
				if [ $result -ne 0 ];then
					retval=1
					echo "$message1"
				else
					file_rev=$(echo $file_rev | tail -2)
				fi
				;;
			eth_switch)
				find_default_file $dev $id
				result=$?
				if [ $result -ne 0 ];then
					retval=1
					echo "$message1"
				else
					file_rev=$(echo $filename | cut -d / -f 5 | sed -e 's/[^0-9]//g')
				fi
				;;
			fan | pcie_switch | support_fpga )
				find_default_file $dev $id
				result=$?
				if [ $result -eq 0 ] ;then
					file_rev=$(echo $filename | awk -F_ '{printf $NF}'| sed -e 's/[Rr]ev//g' | sed -e's/.[a-z]//g')
				else
					retval=1
					echo "$message1"
				fi
				;;
            ddr_eeprom)
   				find_default_file $dev $id
				result=$?
				if [ $result -eq 0 ] ;then
					file_rev=$(echo $filename | awk -F_ '{printf $NF}'| sed -e 's/[Rr]ev//g' | sed -e's/.[a-z]//g')
				else
					retval=1
					echo "$message1"
				fi
             ;;
            ebod)
   				find_default_file $dev $id
				result=$?
				if [ $result -eq 0 ] ;then
					file_rev=$(echo $filename | awk -F_ '{printf $NF}'| sed -e 's/[Rr]ev//g' | sed -e's/.[a-z]//g')
				else
					retval=1
					echo "$message1"
				fi
             ;;

			*)
				;;
	esac
	if [ $retval -eq 0 ];then
		if [ "$device_rev" != "$file_rev" ]; then
			if [ "$device_rev" = "version-unknown" ]; then
				#Change device_rev to NA, then it could add an event log.
				#Otherewise the length of evnet log is larger than 46.
				#Then it fails to add the event log.
				device_rev="NA"
			fi

			message2="${dev}${id}:Rev:$device_rev,Img:$file_rev-mismatch"
			echo "$message2"
		fi
	fi
	return $retval
}
check_device_revision()
# $1: device
{
	local result=0
	local dev=${1}
	local id=0

	case $dev in
			battery)
				device_rev=$(batTool hw_rev | tail -2)
				compare_revision $device_rev $dev

			;;
			eth_switch)
                device_rev=$(switch_config_version.sh 0)
                device_rev=${device_rev:7:2}
				compare_revision $device_rev $dev
			;;
			pcie_switch)
				for id in ${pcieswitch_ids}
				do
					device_rev=$(pcieswitch_eeprom.sh version $id)
					device_rev=$(echo $device_rev | awk '{print $1}')
					compare_revision $device_rev $dev $id
				done
			;;
			fan)
				for id in ${fan_ids}
				do
					filename="/var/run/fan"$id".version"
					if [ -f $filename ]
					then
						device_rev=$(cat $filename | grep Version: | sed -e 's/FC//g' | cut -d " " -f 2)
					else
						# Sleep and recreate the file 
						sleep 5
						device_rev=$(fan_cmds.sh version $id | grep Version: | sed -e 's/FC//g' | cut -d " " -f 2)
					fi
					compare_revision $device_rev $dev $id
				done
			;;
		    support_fpga)
				device_rev=$(cpld_program.sh get_version $dev | tail -1)
				compare_revision $device_rev $dev
				;;
		    ddr_eeprom)
				device_rev=$(ddr_eeprom_version.sh)
                device_rev=${device_rev:8:2}
				compare_revision $device_rev $dev
				;;
		    ebod)
                device_rev=$(ebodcpldtool --get-revision)
				compare_revision $device_rev $dev
				;;
			*)
				;;
	esac
}

filename=""
platform=$(cat /var/run/platform)
components=0
fan_ids="11 12 21 22 31 32"
PLATFORM_MODEL="platform_model"

case $platform in
	RazorM)
		pcieswitch_ids="1"
	#We have only the eth switch image bundled in Razor SP now. Hence this
	#script will only compare the eth switch image version, if invoked.
        supported_devices="eth_switch"
	;;
	RazorL)
		pcieswitch_ids="0 1"
	#We have only the eth switch image bundled in Razor SP now. Hence this
	#script will only compare the eth switch image version, if invoked.
        supported_devices="eth_switch"
	;;
	*)
		echo "Command is not supported on this platform"
		exit 1
	;;
esac

echo Versions that do not match will be printed. 
components=$supported_devices
for device in ${components}
do
	#Some devices needs host is power on then it could check device revsion.
	check_power_status $device
	result=$?
	if [ $result -eq 0 ] ;then
		check_device_revision	$device
	fi
done
exit 0
