#!/bin/sh
# Author  : Mitalee Gujar
# Created : 07/12/04 
# This script mounts the directory containing your images and 
# burns them onto flash

USAGE="Usage: ./burnImage.sh -i|-r|-l|-j|-u|-a|-o"
first=0
ipaddr=172.22.6.68
defDirPath=/home/rlm_ethernet_flash_update

echo

while [ $# -gt 0 ]
do 
	if [ "$1" = "-h" ]
	then
		echo "$USAGE";
		echo "     -a : burn all images (new all jffs2 format)";
		echo "     -o : burn all images (old style initrd format)";
		echo "     -i : burn initrd";
		echo "     -r : burn jffs2 rootfs";
		echo "     -l : burn linux kernel";
		echo "     -j : burn jffs2";
		echo "     -u : burn uboot";
		exit 1;
	fi

	if [ $first -eq 0 ]
	then
#		echo "Enter IP of m/c containing images (eg:fullmonty) : ";
#		read ipaddr;
		echo "Enter dir containing images (press enter for default /home/rlm_ethernet_flash_update): ";
		read dirPath; 
		if [ -z $dirPath ]
		then
			dirPath=$defDirPath;
		fi
		#route del default gw 172.22.6.1;
		#mkdir /mnt/nfsxfer;
		source_file=$ipaddr:${dirPath};
		echo $source_file;
		mount -o soft,intr $source_file /mnt/nfsxfer;
		sleep 10  # This is to be able to do ^C in case of typo #
		first=1;
	fi
	
	case "$1" in
		-i) eraseall /dev/mtd/7;
	           dd if=/mnt/nfsxfer/initrd.boot of=/dev/mtd/7;;
	
		-r) eraseall /dev/mtd/7;
	           dd if=/mnt/nfsxfer/jffs2_rootfs.img of=/dev/mtd/7;;

		-l) eraseall /dev/mtd/8;
	           dd if=/mnt/nfsxfer/vmlinux.UBoot of=/dev/mtd/8;;

		-j) umount /mnt/logs;
		       eraseall /dev/mtd/6;
	           dd if=/mnt/nfsxfer/jffs2.img of=/dev/mtd/6;
			   mount -t jffs2 /dev/mtdblock/6 /mnt/logs;;

		-u) eraseall /dev/mtd/9;
		   dd if=/mnt/nfsxfer/u-boot.bin of=/dev/mtd/9;;
		
		-a) eraseall /dev/mtd/7;
	           dd if=/mnt/nfsxfer/jffs2_rootfs.img of=/dev/mtd/7;
		   eraseall /dev/mtd/8;
	           dd if=/mnt/nfsxfer/vmlinux.UBoot of=/dev/mtd/8;
		   umount /mnt/logs;
		       eraseall /dev/mtd/6;
	           dd if=/mnt/nfsxfer/jffs2.img of=/dev/mtd/6;
			   mount -t jffs2 /dev/mtdblock/6 /mnt/logs;
		   eraseall /dev/mtd/9;
		   dd if=/mnt/nfsxfer/u-boot.bin of=/dev/mtd/9;;

		-o) eraseall /dev/mtd/7;
	           dd if=/mnt/nfsxfer/initrd.boot of=/dev/mtd/7;
		   eraseall /dev/mtd/8;
	           dd if=/mnt/nfsxfer/vmlinux.UBoot of=/dev/mtd/8;
		   umount /mnt/logs;
		       eraseall /dev/mtd/6;
	           dd if=/mnt/nfsxfer/jffs2.img of=/dev/mtd/6;
			   mount -t jffs2 /dev/mtdblock/6 /mnt/logs;
		   eraseall /dev/mtd/9;
		   dd if=/mnt/nfsxfer/u-boot.bin of=/dev/mtd/9;;
esac
shift
done
umount /mnt/nfsxfer
exit 0
