#!/bin/sh
. /usr/local/bin/sig_catcher

BBSP=`cat /sys/class/hwmon/bbsp`
PLATFORM=`cat /var/run/platform`
HOST_POWER_STATE=`ipmi power status`
OS_STR=$(cat /var/run/os_str)
if [ "$HOST_POWER_STATE" == "Host Power is off" ]
then 
	echo $HOST_POWER_STATE
else
	echo -n "BBSP = 0x$BBSP -- "
	case "$BBSP" in
		"00") 	echo "System Software has cleanly shut down" ;;
		"01")	echo "Memory Intialization in progress" ;;
		"02")	echo "NVMEM Intialization in progress" ;;
		"03")   echo "Memory Intialization done" ;;
		"04")	echo "Restoring chipset configuration" ;;
		"05")	echo "User has entered Setup" ;;
		"13")	echo "Booting to Bootloader" ;;
		"1f")	echo "BIOS is starting up" ;;
		"20")	echo "Bootloader is running" ;;
		"21")	echo "Bootloader is programming the primary firmware" ;;
		"22")	echo "Bootloader is programming the secondary firmware" ;;
		"2f")	echo "$OS_STR is running" ;;
		"81")   echo "No system memory is installed or other fatal error during memory initialization" ;;
		*)		echo "Unknown" ;;
	esac
fi
