#!/bin/sh

count=0
while [ -z "$(/usr/local/bin/ipmi sensors get Bat_Pack_Invalid | grep '\[State Deasserted\]')" ] && [ "$count" -lt 5 ] ; do
    sleep 1
    count=$((count+1))
done

if [ "$count" -eq 5 ] ; then
    #Make sure battery has charger enabled and run wakeup sequence
    /usr/local/bin/ipmi oem battery load wakeup

    count=0
    #Allowing Time for Bat_Pack_Invalid (as required) to change its state to Deasserted post battery load wakeup.
    #This will never stop boot process since bat_wakeup.sh executes in background.
    while [ -z "$(/usr/local/bin/ipmi sensors get Bat_Pack_Invalid | grep '\[State Deasserted\]')" ] && [ "$count" -lt 5 ] ; do
	sleep 4
	count=$((count+1))
    done

    if [ "$count" -eq 5 ] ; then
        #Failure
        /usr/local/bin/sel_logger "SP.notice" "Failure on battery wake up attempt"
    else
        #Successfully woke up
        /usr/local/bin/sel_logger "SP.notice" "Successfully woke up the battery"
    fi
fi
