#!/bin/sh

# tmp files used
frulinefile="/tmp/fruline.txt"
fruscanbusyfile="/tmp/fruscanbusyfile.log"

# fru commands
frucmd="/usr/local/bin/fruprog"
cmdfrulist="$frucmd list"
cmdfrushow="$frucmd show"
cmdfrurescan="/usr/local/bin/ipmitool -A none -H 127.0.0.1 raw 0x30 0x73 0x15 0x03 0x00 0x02"

# dump out fru data content
# $1 fruid
dumpfru()
{
	if [ -z "$1" ]
	then
		return 1
	fi

	$cmdfrushow $1	
	return 0
}

# Routine to ensure all NetApp FRUs are not reporting
#  device access failure. FRU rescan is needed if this
#  is detected
scanbadfru()
{
	while read line
	do
		echo $line > $frulinefile
		read arg1 arg2 < $frulinefile
		echo $arg1 | awk '/^[0-9]+$/' > $frulinefile
		read arg1 < $frulinefile

		dumpfru $arg1 | grep "inventory data access failed"
		if [ "$?" -eq 0 ]
		then
			/usr/bin/logger "Detect FRUID $arg1 ($arg2) access fail during boot"
			/usr/bin/logger "Rescanning all FRU devices to update FRU log state"
			$cmdfrurescan
			return 1
		fi
	done
	return 0
}


# Set busy file until this script is done.
touch $fruscanbusyfile

# wait until ipmi message handler is up
while [ ! -f "/tmp/ipmiMsgHdlrUp" ]
do
        sleep 1;
done

# wait until sensor monitor completes one rescan

LIMIT=60
counter=1
while [ ! -f "/tmp/sensorMonitorTaskUp" ]
do
	 if [ $counter -ne $LIMIT ]
	 then
		 sleep 1;
		 let counter++
	 else
		 /usr/bin/logger "sensorMonitorTaskUp file not created"
		 exit 1;
	 fi
done

# give 1 second to settle
sleep 1

/usr/bin/logger "Post boot FRU rescan started"

# Give 5 attempts to fix any NetApp FRUs that have access failue by rescanning FRU log
for count in 1 2 3 4 5
do
	$cmdfrulist | scanbadfru
	if [ "$?" -eq 1 ]
	then
		continue
	else
		break
	fi
done

rm -f $frulinefile $fruscanbusyfile
rm -f /tmp/sensorMonitorTaskUp

# Cache FRU info used by splog
/etc/init.d/fru_cache.sh


