#!/bin/sh

bbspStatus=""

# persistence files
LOGFILE_FORCED="/mnt/logs/ipmi/bat_force_update.log"
FAILEDLOGFILE_FORCED="/mnt/logs/ipmi/bat_force_update_failed.log"

# files intended to live until next SP reboot
LOGFILE_AUTO="/tmp/bat_last_auto_udpate.log"
BUSYFILE="/tmp/batteryUpdateOngoing"

FRUSCANBUSYFILE="/tmp/fruscanbusyfile.log"

dump_bat_status()
{
	/usr/local/bin/batTool sealCheck >>  $LOGFILE_FORCED
	/usr/local/bin/batTool info >>  $LOGFILE_FORCED
	/usr/local/bin/batTool regDump >>  $LOGFILE_FORCED
	/usr/local/bin/batTool sealCheck >>  $LOGFILE_FORCED
}

logall_forced_msg()
{
	/usr/bin/logger "$MSG"
	echo "$MSG" >> "$LOGFILE_FORCED"
}

logall_auto_msg()
{
	/usr/bin/logger "$MSG"
	echo "$MSG" >> "$LOGFILE_AUTO"
}

resync_fru()
{
	sleep 5
	/usr/local/bin/batTool rescan
}

# The good stuff starts here

# wait until ipmi message handler is up
while [ ! -f "/tmp/ipmiMsgHdlrUp" ]
do
	sleep 1;
done

# make sure fru scan get started first
sleep 3;

# loop until the fru rescan by checking the busy fru scan file
while [ -f "$FRUSCANBUSYFILE" ]
do
	# sleep 3 seconds
	sleep 3;
done

/usr/bin/logger "Battery update started"

# Force battery update to default firmware if revision is not F0 or newer

# Just in case if user updated battery to pre 'F0' revision
# this forces another force update evaluation
/usr/local/bin/batTool revCheck
if [ "$?" -ne 0 ]
then
	rm -f $LOGFILE_FORCED
fi

if [ ! -f "$LOGFILE_FORCED" ]
then

	# Capture the timestamp even though it might not be synced to the actual time
	echo "Timestamp might not be current:" >> $LOGFILE_FORCED
	date >> $LOGFILE_FORCED

	MSG="Validating if battery revision is current..."
	logall_forced_msg

	echo >> $LOGFILE_FORCED
	echo "Current battery info:" >> $LOGFILE_FORCED
	dump_bat_status

	# Revision check if battery is running F0 or newer
	/usr/local/bin/batTool revCheck >> $LOGFILE_FORCED
	# one more time to catch return status
	/usr/local/bin/batTool revCheck
	RETCODE=$?
	if [ "$RETCODE" -eq 1 ]
	then
		# Actual update starts here
		MSG="Battery FW is running an older revision then F0. Starting force update..."
		logall_forced_msg
		touch $BUSYFILE

		/usr/local/bin/battery flash force
		if [ "$?" -ne 0 ]
		then
			MSG="!!! WARNING: Forced battery firmware to default revision failed !!!"
			logall_forced_msg
			# Move the 
			mv  $LOGFILE_FORCED $FAILEDLOGFILE_FORCED
		fi
	
		rm -f $BUSYFILE

		MSG="Battery firmware force update is done"
		logall_forced_msg

		# Get the new battery info here
		echo >> $LOGFILE_FORCED
		echo "       *********************************************************" >> $LOGFILE_FORCED
		echo >> $LOGFILE_FORCED
		echo "New firmware battery info:" >> $LOGFILE_FORCED
		dump_bat_status
		resync_fru
		exit 0;
	elif [ "$RETCODE" -eq 2 ]
	then
		MSG="Battery TI version is not 110"
		logall_forced_msg
		echo >> $LOGFILE_FORCED
		exit 0;
	elif [ "$RETCODE" -eq 3 ]
	then
		MSG="Battery access failed"
		logall_forced_msg
		echo >> $LOGFILE_FORCED
		exit 0;
	fi

	# Print no force update happened
	MSG="Battery firmware is up to date at revision 'F0' or newer"
	logall_forced_msg
	echo >> $LOGFILE_FORCED
fi

# Auto update starts here
touch $BUSYFILE
MSG="Battery auto update checking begins..."
logall_auto_msg

# BBSP checking for ONTAP status
if [ ! -f /sys/class/hwmon/bbsp ]
then
	MSG="Cannot find bbsp file"
	logall_auto_msg
	echo >> $LOGFILE_AUTO
	rm -f $BUSYFILE
	exit 1
fi

MSG="Battery update checking bbsp content: `cat /sys/class/hwmon/bbsp`"
logall_auto_msg

# Dump out BBSP stats to see if ONTAP is running
read bbspStatus < /sys/class/hwmon/bbsp

# Abort battery auto update if ONTAP is running (bbsp == 2f)
if test "$bbspStatus" == 2f
then
	MSG="Filer OS is running. Skipping battery firmware auto update check"
	logall_auto_msg
	echo >> $LOGFILE_AUTO
	rm -f $BUSYFILE
	exit 1
fi

# Perform battery firmware auto update
MSG="Start battery firmware auto update checking..."
logall_auto_msg

/usr/local/bin/battery auto boot >> $LOGFILE_AUTO

# rescan fru after update happened
if [ "$?" -eq 1 ]
then
	resync_fru
	/usr/bin/logger "Rescanning all frus due to battery update"
fi

MSG="Battery firmware auto update checking done"
logall_auto_msg

echo >> $LOGFILE_AUTO

rm -f $BUSYFILE
exit 0

